set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2134',
      '13401420',
      '03020442',
      NULL,
      '22433002',
      '42143433',
      '24044344',
      '41324020',
      '43121304',
      '00202431',
      '40401420',
      '12014303',
      '20444041',
      NULL,
      '02400100',
      '40203133',
      '11044000',
      '43301043',
      '40304234',
      NULL,
      '43043032',
      '12244400',
      '03443211',
      '04333312',
      NULL,
      '40302031',
      '01212143',
      '20443431',
      '01024103',
      '30220401',
      NULL,
      '34201142',
      '41212141',
      '42402333',
      NULL,
      '04204024',
      '44342320',
      '23324400',
      '14002002',
      '10110401',
      '33022411',
      NULL,
      '30232241',
      '11020324',
      '21124423',
      '431',
      '23',
      NULL,
      NULL,
      '1224322',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339227,
      NULL,
      ' 0-14-1991',
      52,
      NULL,
      4.381223,
      NULL,
      2.323785,
      10,
      NULL,
      9.052724,
      5,
      1,
      NULL,
      NULL,
      NULL,
      5,
      29.440424,
      7.200116,
      10,
      11,
      NULL,
      NULL,
      44.600634,
      13.705223,
      2,
      1.456303,
      1.217906,
      21,
      119.286694,
      NULL,
      NULL,
      138,
      133.040444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.081555,
      0.253880,
      17,
      5,
      1,
      2,
      10.475030,
      0.335050,
      NULL,
      1,
      1,
      0.914612,
      2.826498,
      0.650203,
      1.588103,
      NULL,
      0,
      0.461201,
      1.162534,
      0.154105,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-14-1979',
      38.615520,
      42,
      6,
      22.736754,
      8.499145,
      2,
      '10- 5-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      18.450740,
      15.941060,
      35.604976,
      11.217771,
      NULL,
      21.566835,
      21,
      NULL,
      26.779750,
      NULL,
      21,
      ' 9-14-1980',
      0,
      4,
      1.346013,
      7,
      9,
      1.600263,
      2.283214,
      ' 1-15-1974',
      18.500373,
      4.581661,
      ' 1- 4-1977',
      9.940887,
      0.927147,
      NULL,
      NULL,
      1.605059,
      4,
      0,
      4,
      1,
      17,
      NULL,
      1,
      3.163858,
      0.252697,
      NULL,
      1.279755,
      3,
      1,
      ' 6-18-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49.568116,
      NULL,
      34,
      ' 9-25-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      ' 6- 7-1974',
      NULL,
      14,
      7.990416,
      ' 6- 0-1982',
      NULL,
      NULL,
      NULL,
      4,
      94.482509,
      17.721070,
      84,
      NULL,
      26,
      NULL,
      140.485229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


