set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      '3',
      '2',
      '2',
      '3',
      '2',
      '0',
      '1',
      '1',
      '1',
      NULL,
      NULL,
      '0',
      '2',
      '4',
      '4',
      '0',
      '1',
      '0',
      '0',
      NULL,
      '0',
      '3',
      '',
      '3',
      '',
      '4',
      NULL,
      '4',
      NULL,
      '1',
      '',
      '',
      '4',
      '3',
      '3',
      '3',
      '2',
      '4',
      NULL,
      '0',
      '4',
      '0',
      '4',
      '140',
      '12',
      22.384212,
      20,
      '1214302',
      1.495472,
      54.247916,
      3,
      NULL,
      '133214',
      NULL,
      ' 8- 4-1988',
      ' 8- 8-1995',
      31.247775,
      NULL,
      1.413390,
      NULL,
      6,
      8.969957,
      21,
      NULL,
      19.496708,
      4,
      14,
      NULL,
      28.590129,
      3,
      31,
      23.163435,
      5,
      1.629932,
      22,
      11.856603,
      6,
      13,
      7,
      3.977334,
      1.761197,
      52.048435,
      132.176838,
      53.636737,
      NULL,
      17,
      0,
      ' 9-27-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.752422,
      60,
      14.184099,
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60.031678,
      NULL,
      1,
      59.064213,
      1.756565,
      0,
      29.780200,
      NULL,
      NULL,
      NULL,
      ' 4-20-1974',
      9,
      NULL,
      NULL,
      53,
      46.045061,
      3.326885,
      82.154786,
      29,
      0.519294,
      39,
      48,
      74.995909,
      ' 5-17-1992',
      3,
      8,
      1,
      NULL,
      41.377100,
      4,
      2,
      ' 3-19-2003',
      5,
      4.193234,
      ' 4- 1-1974',
      NULL,
      8,
      8.402117,
      10.646075,
      13.468456,
      6.877119,
      NULL,
      4.078778,
      1.480306,
      18.299877,
      2.204276,
      NULL,
      3.139875,
      11.096392,
      7,
      1,
      0,
      NULL,
      ' 5-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      '10-26-1976',
      39.013777,
      ' 5-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      ' 9-12-1981',
      NULL,
      NULL,
      0,
      ' 3-11-1974',
      NULL,
      NULL,
      NULL,
      3,
      11,
      NULL,
      NULL,
      ' 5- 3-1989',
      39,
      2.913604,
      191.549357,
      ' 7- 6-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


