set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '2',
      NULL,
      '1',
      NULL,
      '2',
      '1',
      '4',
      '3',
      '4',
      '4',
      '4',
      '1',
      NULL,
      '0',
      '4',
      '0',
      '2',
      '0',
      '0',
      '2',
      NULL,
      '1',
      '',
      '2',
      '',
      '4',
      NULL,
      '4',
      '1',
      '0',
      '',
      '',
      '3',
      '0',
      '0',
      '0',
      '4',
      '1',
      '3',
      '2',
      NULL,
      '4',
      '4',
      '343',
      '32234343',
      34.092256,
      53,
      '1411224',
      3.230287,
      241.561958,
      0,
      0,
      NULL,
      NULL,
      ' 2- 1-2002',
      ' 9- 3-1994',
      24,
      NULL,
      NULL,
      7,
      11.267137,
      NULL,
      NULL,
      17.163495,
      13,
      10,
      NULL,
      9,
      NULL,
      12.028716,
      20.785607,
      8,
      0.112986,
      0.399137,
      28.795574,
      8,
      14.727190,
      10.388669,
      42.673990,
      7.123094,
      1.426463,
      24.786831,
      153.456563,
      33,
      69.954947,
      68.323618,
      151,
      ' 3-26-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.517749,
      0,
      4,
      NULL,
      3,
      ' 7- 5-1979',
      3,
      1,
      66,
      1,
      6.376102,
      58.642544,
      5.653574,
      1,
      2,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1999',
      NULL,
      NULL,
      63,
      14,
      56,
      23.856344,
      50.831589,
      NULL,
      80.106215,
      79,
      43.670813,
      43,
      NULL,
      3.920217,
      4,
      9.410942,
      33,
      12.338284,
      NULL,
      1.117625,
      ' 6- 9-1987',
      6.181427,
      4.840524,
      ' 5-29-1984',
      9.526377,
      5.260368,
      NULL,
      11,
      4,
      1,
      1,
      5.016347,
      NULL,
      50.373144,
      0,
      0,
      2.243990,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782256,
      '10-12-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 6-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-25-1984',
      17,
      ' 3- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.083987,
      ' 1-18-1995',
      NULL,
      1,
      9.799725,
      ' 7- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      47,
      '10- 6-1994',
      23.159615,
      0.396202,
      122.023646,
      ' 0- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


