set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '3',
      '4',
      NULL,
      NULL,
      '4',
      '4',
      '3',
      '0',
      NULL,
      NULL,
      '3',
      '2',
      '2',
      '0',
      '2',
      '0',
      NULL,
      NULL,
      '0',
      '4',
      '1',
      '1',
      '',
      '3',
      '',
      '2',
      '0',
      '1',
      '3',
      '0',
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      '0',
      '3',
      NULL,
      '1',
      '4',
      '2',
      '0',
      '2',
      '011',
      '02021331',
      95,
      16.506424,
      '3421413',
      0.429536,
      227.269496,
      NULL,
      1,
      '321432',
      5,
      ' 3- 9-1991',
      ' 0-13-1986',
      NULL,
      149.434647,
      5,
      11.699117,
      14,
      2,
      21,
      NULL,
      6.577772,
      8,
      16,
      6.082810,
      15,
      16.099125,
      9.105977,
      17.802838,
      7,
      2,
      NULL,
      NULL,
      NULL,
      1,
      50,
      NULL,
      1,
      19.953750,
      113,
      NULL,
      110,
      60,
      52,
      ' 1-25-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      20.284295,
      10,
      2.795618,
      17,
      6.345723,
      ' 6- 3-1987',
      1.529452,
      1,
      117.496917,
      0,
      3.926638,
      0,
      0.109751,
      1.393536,
      14.462452,
      NULL,
      NULL,
      NULL,
      '11- 0-1997',
      57.335567,
      53.221879,
      66.290502,
      NULL,
      NULL,
      20,
      61,
      5,
      NULL,
      13,
      NULL,
      3.637566,
      ' 7- 4-1975',
      NULL,
      4.706521,
      14,
      5.830035,
      28,
      9,
      NULL,
      ' 3-12-1976',
      0,
      NULL,
      NULL,
      7.384861,
      0.481778,
      NULL,
      0,
      11.300159,
      6,
      0.146197,
      5.727150,
      NULL,
      40,
      0.872334,
      1.261000,
      0,
      17.965519,
      6,
      2.003942,
      0.221669,
      NULL,
      ' 7- 6-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      64.590900,
      13.339541,
      ' 5-23-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1979',
      42,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 6-21-1986',
      31,
      1.342621,
      NULL,
      ' 2-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201506,
      NULL,
      ' 9- 5-1995',
      69,
      1,
      228,
      ' 5-23-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


