set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437113';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1313',
      NULL,
      NULL,
      '24302041',
      '11012314',
      '30122420',
      '23132234',
      '33142301',
      '10101104',
      '10320311',
      '32001133',
      '12004131',
      '32344302',
      '20334013',
      '43304420',
      '41204431',
      '30401202',
      '42144100',
      '14333331',
      NULL,
      '33204004',
      '40013324',
      '20121343',
      '42401140',
      '03322314',
      '43221142',
      '14001211',
      '11030430',
      NULL,
      '34110420',
      '42142240',
      '02433124',
      '41013210',
      NULL,
      NULL,
      '23334312',
      '43303003',
      NULL,
      NULL,
      NULL,
      '10141314',
      '01100311',
      '20420414',
      '04303203',
      '13442232',
      '412',
      NULL,
      NULL,
      NULL,
      '4310423',
      2.218458,
      0,
      NULL,
      NULL,
      '324102',
      3,
      '11- 0-1995',
      ' 4- 5-1996',
      25.847874,
      NULL,
      6,
      5,
      0.638086,
      10.386430,
      5.802596,
      8,
      NULL,
      2,
      2.117997,
      6.253194,
      7.440768,
      0,
      NULL,
      3,
      NULL,
      0.312950,
      4,
      4.269827,
      7,
      0,
      79.029708,
      15.404653,
      1,
      54,
      NULL,
      15,
      62,
      NULL,
      17,
      NULL,
      22,
      8,
      2,
      7.517833,
      43,
      114.368141,
      ' 9-26-1994',
      3,
      8,
      5.124718,
      1.712058,
      2,
      1.273598,
      4,
      6,
      NULL,
      1,
      2.498569,
      1,
      NULL,
      2,
      1,
      0.927128,
      0.633652,
      1,
      1,
      7.691958,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-12-1987',
      25.342608,
      50.546566,
      17.093855,
      26.954404,
      NULL,
      3,
      ' 9- 7-1974',
      1,
      1,
      43,
      1.021128,
      1,
      99,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1984',
      80.768623,
      21.574837,
      47,
      19,
      21,
      91,
      103.231590,
      7,
      96.764549,
      NULL,
      22.967728,
      NULL,
      ' 6-17-1995',
      20.960406,
      NULL,
      NULL,
      19.238053,
      NULL,
      41,
      6,
      ' 3-23-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.314977,
      38.461185,
      NULL,
      NULL,
      NULL,
      NULL,
      12.804083,
      '10-11-1991',
      NULL,
      ' 1- 6-1996',
      NULL,
      NULL,
      ' 6- 5-2001',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 1- 7-2001',
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.202224,
      NULL,
      2,
      '11-19-1974',
      3.890086,
      0.650880,
      51.668814,
      ' 9-21-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


