set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2213',
      '44344122',
      '14342343',
      '10033001',
      '12122021',
      '12404410',
      NULL,
      '01333240',
      '32122122',
      NULL,
      '02213000',
      '40214214',
      '04131240',
      NULL,
      NULL,
      '22204214',
      '14024223',
      '11221110',
      '32032440',
      '30131324',
      '01324223',
      '03341330',
      NULL,
      NULL,
      '42241142',
      '43210324',
      '24302222',
      '20042013',
      '24204434',
      '21420221',
      '33321032',
      NULL,
      '22132324',
      '22010041',
      '21433404',
      NULL,
      NULL,
      '32000103',
      '44202001',
      '41004241',
      NULL,
      '43024041',
      NULL,
      '01333022',
      '21104121',
      '',
      NULL,
      NULL,
      NULL,
      '3442214',
      0,
      1.467404,
      0,
      NULL,
      '343300',
      NULL,
      NULL,
      NULL,
      103.903067,
      NULL,
      1.389245,
      NULL,
      17.916512,
      0.846361,
      6.172419,
      5.191347,
      NULL,
      4,
      5.144594,
      3,
      NULL,
      4.960974,
      4,
      2,
      3,
      7.013539,
      2.610786,
      5,
      24,
      4.372728,
      NULL,
      10.134409,
      NULL,
      0.586536,
      24,
      21,
      NULL,
      3,
      NULL,
      ' 7-27-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810680,
      15.011596,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.705225,
      NULL,
      2,
      NULL,
      8.140770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-10-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      25,
      10,
      NULL,
      15.961351,
      0.657669,
      38.319811,
      7,
      22,
      NULL,
      13,
      53.135110,
      ' 5-13-2003',
      0,
      NULL,
      0,
      30.192524,
      16,
      3,
      NULL,
      '11-25-1999',
      5,
      1.277245,
      ' 7-10-1975',
      5.576027,
      0,
      NULL,
      NULL,
      0.804901,
      1.264035,
      NULL,
      0,
      NULL,
      NULL,
      2.520340,
      1.206145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-26-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.574607,
      10.420228,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      6.147348,
      NULL,
      0.668984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.558224,
      NULL,
      0.658846,
      2,
      NULL,
      1,
      0.759430,
      0.233623,
      NULL,
      ' 6-29-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-15-2002',
      NULL);
commit;
end;
/


