set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3102',
      '43140432',
      '32202323',
      '40303130',
      '24324144',
      '03341241',
      '32044202',
      NULL,
      '40310310',
      '30224123',
      '40420424',
      '12003440',
      '40401232',
      NULL,
      '21033422',
      NULL,
      '44440042',
      '24230030',
      '12023421',
      '31202330',
      NULL,
      '34343003',
      NULL,
      '11121042',
      '14320141',
      '12101102',
      NULL,
      '33023330',
      '20412200',
      '44113432',
      '00120003',
      '30322000',
      '22044212',
      '01342423',
      NULL,
      '20331221',
      '01321440',
      '32144333',
      NULL,
      '14130431',
      '32444243',
      '04102220',
      NULL,
      '10320021',
      '04100012',
      '113',
      NULL,
      15.616493,
      11,
      '1031012',
      NULL,
      62,
      2,
      NULL,
      '221020',
      3.632203,
      NULL,
      NULL,
      104.080005,
      3,
      1,
      0,
      NULL,
      15,
      NULL,
      8,
      10,
      9,
      18,
      4,
      26,
      5.374668,
      4.841786,
      1.128380,
      0.349568,
      0.806671,
      3,
      10,
      23.260531,
      NULL,
      7.415525,
      4.154937,
      0.509941,
      12,
      131.178224,
      41,
      127.176235,
      113,
      20,
      '11- 9-2000',
      28.741074,
      0,
      26.429054,
      3.992734,
      138,
      NULL,
      ' 5- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      13.346696,
      46,
      4,
      5.226715,
      NULL,
      NULL,
      0,
      NULL,
      61,
      0.888996,
      1,
      5,
      NULL,
      1,
      77,
      NULL,
      NULL,
      NULL,
      ' 3-15-1985',
      NULL,
      27,
      NULL,
      29.903879,
      16,
      38,
      NULL,
      33,
      16.099863,
      45.587695,
      37,
      13,
      ' 7-14-2003',
      18,
      NULL,
      31.307539,
      83.064982,
      NULL,
      175.777147,
      NULL,
      NULL,
      6.008082,
      8.896767,
      ' 6-20-1990',
      5,
      2.684723,
      NULL,
      9,
      5,
      6.186857,
      7,
      5,
      1.899998,
      59.093119,
      35.972755,
      0,
      0,
      NULL,
      0,
      11,
      NULL,
      0,
      ' 3-13-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.349886,
      ' 9- 6-1996',
      18.049054,
      NULL,
      NULL,
      10,
      NULL,
      21,
      19,
      '11-18-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2-13-1995',
      NULL,
      11,
      3,
      ' 1- 8-1991',
      NULL,
      178,
      ' 1-11-1984',
      0,
      32.507843,
      NULL,
      2.570259,
      ' 3-15-1989',
      65,
      0.383189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


