set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '3',
      '0',
      '0',
      '3',
      '2',
      '3',
      '4',
      '1',
      NULL,
      '4',
      NULL,
      '3',
      '1',
      '1',
      '4',
      '0',
      NULL,
      '3',
      '4',
      '1',
      '4',
      '1',
      '',
      '2',
      '',
      '2',
      '1',
      NULL,
      '0',
      NULL,
      '',
      NULL,
      '3',
      '1',
      '2',
      '1',
      '1',
      '4',
      '2',
      '0',
      '1',
      NULL,
      '2',
      '340',
      NULL,
      10.174739,
      20,
      NULL,
      3.392223,
      NULL,
      0,
      NULL,
      '314012',
      3.632825,
      ' 4-13-1987',
      NULL,
      101.413964,
      52,
      12,
      NULL,
      5,
      8,
      NULL,
      9,
      7,
      3.067461,
      5,
      2,
      3.907622,
      3.334385,
      4,
      NULL,
      3,
      8,
      37.534198,
      1,
      NULL,
      3.225465,
      NULL,
      13.997523,
      1.106767,
      24,
      46.434741,
      14,
      52.924394,
      51,
      6.869212,
      ' 4-22-1997',
      9.291680,
      20.769232,
      23.100557,
      21.216968,
      NULL,
      60,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.285577,
      100,
      33.200575,
      1.425779,
      60.372937,
      1.286690,
      ' 4-22-1980',
      0.988171,
      NULL,
      41.556668,
      NULL,
      1.078806,
      104,
      0.086221,
      1,
      76.713310,
      NULL,
      NULL,
      NULL,
      NULL,
      68.407896,
      49,
      65,
      16,
      30,
      35,
      54,
      NULL,
      NULL,
      2.810443,
      23,
      23,
      '11-18-1983',
      4.877213,
      9.288108,
      2.323828,
      0.910975,
      NULL,
      2.392274,
      2,
      ' 0-22-1999',
      16,
      9,
      ' 6-10-2002',
      3,
      0,
      NULL,
      4,
      15,
      2,
      3.977701,
      0.824512,
      0.877025,
      NULL,
      1,
      0.669885,
      5,
      21.492619,
      4.600574,
      NULL,
      NULL,
      1.872285,
      ' 9- 4-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.663849,
      ' 1-16-2002',
      NULL,
      ' 7-17-1983',
      0.844219,
      9,
      ' 3-18-2003',
      101.227741,
      NULL,
      ' 5- 5-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      37,
      0.014873,
      NULL,
      ' 8-29-1996',
      1.106563,
      NULL,
      ' 5-25-1984',
      7.082013,
      118,
      4,
      43.228592,
      ' 8- 3-1987',
      22,
      0.763445,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


