set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '1',
      '0',
      '1',
      '0',
      '3',
      '3',
      '1',
      NULL,
      '4',
      '2',
      '0',
      '2',
      '2',
      '4',
      '2',
      '0',
      '0',
      '2',
      NULL,
      '1',
      '1',
      NULL,
      '',
      NULL,
      '',
      '4',
      NULL,
      '1',
      '0',
      '2',
      '',
      NULL,
      '3',
      '4',
      '2',
      NULL,
      NULL,
      '2',
      '4',
      '4',
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      70,
      17,
      '0003432',
      3,
      129.068112,
      1,
      0,
      NULL,
      4.999658,
      '10-29-1999',
      ' 6-24-1989',
      NULL,
      104,
      13.643841,
      3.299591,
      19.714455,
      6,
      26,
      6,
      NULL,
      NULL,
      8,
      9,
      10.282192,
      NULL,
      NULL,
      1,
      6,
      10,
      3,
      3,
      9,
      5,
      42.797181,
      NULL,
      0,
      55.218045,
      28,
      NULL,
      11.961189,
      101.476003,
      109.365015,
      ' 4- 2-2002',
      NULL,
      NULL,
      17,
      21,
      NULL,
      64,
      ' 4-15-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      30.225737,
      6,
      0.440926,
      36.697232,
      0,
      NULL,
      0.736455,
      1.203254,
      90.460060,
      1,
      NULL,
      89.659516,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.415482,
      41,
      11,
      NULL,
      3.766495,
      3,
      23,
      38,
      49,
      26.496726,
      32.914510,
      60.116072,
      ' 9-25-1995',
      21.133796,
      21.512057,
      12,
      15.456296,
      24.085011,
      20,
      NULL,
      NULL,
      8,
      2.389631,
      '10-15-1977',
      4,
      3.177160,
      NULL,
      NULL,
      15,
      0.336227,
      1,
      NULL,
      0.115892,
      NULL,
      1.016446,
      0.422997,
      NULL,
      3,
      1,
      0.689948,
      NULL,
      0.871225,
      ' 5- 7-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 7-1997',
      32,
      ' 2- 6-1995',
      0.831427,
      2,
      '11-17-1982',
      68.467443,
      4.643068,
      ' 2-15-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      7,
      '11- 7-1974',
      4,
      2.447808,
      NULL,
      ' 1- 6-1990',
      0.524781,
      NULL,
      ' 3- 5-1999',
      1,
      25,
      6,
      26,
      ' 7- 4-1985',
      42.154876,
      1,
      54.688147,
      ' 2-16-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


