set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '1',
      '3',
      '0',
      '1',
      '2',
      '1',
      '2',
      '4',
      '2',
      '3',
      '4',
      NULL,
      NULL,
      '4',
      '4',
      '4',
      '2',
      '1',
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '4',
      '',
      '4',
      '2',
      '4',
      '1',
      NULL,
      '',
      '',
      NULL,
      '1',
      '0',
      '1',
      '1',
      '3',
      NULL,
      '2',
      '0',
      '0',
      '2',
      '041',
      '34414444',
      60.224847,
      29.999177,
      '3001244',
      1.567646,
      0.492861,
      NULL,
      NULL,
      '101403',
      2,
      NULL,
      ' 6- 6-1982',
      69.440243,
      100.031035,
      NULL,
      NULL,
      7,
      10,
      101.378078,
      18.442403,
      15,
      6,
      38.734659,
      0,
      14,
      NULL,
      16,
      12.691129,
      25.887190,
      NULL,
      27,
      1,
      60,
      0.750216,
      45,
      7,
      NULL,
      34,
      NULL,
      69,
      137,
      NULL,
      184.368832,
      ' 7-24-1999',
      45,
      49,
      4,
      18.465345,
      199.293084,
      57,
      ' 4-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.402670,
      6,
      3.852679,
      2.540524,
      9.997375,
      7.602165,
      NULL,
      1.890782,
      1.004182,
      58,
      0,
      1.216099,
      14.888096,
      1,
      5.694792,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-19-2001',
      73,
      NULL,
      63.045039,
      52.520649,
      67.034553,
      87.733099,
      11.671675,
      27,
      35,
      90,
      21.898184,
      22,
      ' 5-12-1999',
      NULL,
      12.771765,
      24,
      43,
      74,
      75,
      4,
      ' 4- 6-1982',
      NULL,
      27,
      ' 6- 8-1988',
      5.349995,
      6.679373,
      5,
      NULL,
      NULL,
      1.995519,
      0,
      10,
      1.778875,
      NULL,
      2,
      1.366021,
      NULL,
      NULL,
      6,
      1.431061,
      NULL,
      0,
      ' 8-25-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208608,
      '11-26-1993',
      NULL,
      NULL,
      NULL,
      39.113874,
      NULL,
      18,
      ' 1- 7-1981',
      14.275106,
      11,
      ' 5- 2-1997',
      117,
      115,
      ' 5-21-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '11- 5-1999',
      25,
      24,
      34,
      NULL,
      0,
      130.917994,
      ' 0- 7-1975',
      19,
      20.218681,
      18,
      43,
      ' 1-12-1986',
      NULL,
      1,
      49.117504,
      ' 9-27-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


