set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '2',
      '3',
      '0',
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3',
      NULL,
      '3',
      '3',
      '0',
      '2',
      '1',
      '4',
      '0',
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '',
      '2',
      '',
      '1',
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '',
      '2',
      '0',
      '0',
      '3',
      '1',
      NULL,
      '2',
      '0',
      '3',
      '1',
      '2',
      '203',
      NULL,
      16.051682,
      NULL,
      '2301100',
      3,
      19.313924,
      3,
      1,
      '222400',
      6,
      ' 1-19-1985',
      '11- 8-2003',
      52,
      NULL,
      NULL,
      28,
      15.806792,
      17.856078,
      29,
      17,
      8.048130,
      4.913391,
      NULL,
      1.555755,
      NULL,
      NULL,
      23.524277,
      NULL,
      2,
      16.080904,
      5.692546,
      18.353160,
      32.558577,
      NULL,
      NULL,
      19.225345,
      1.231121,
      102.963646,
      NULL,
      NULL,
      192,
      160,
      174.423269,
      ' 7- 9-1974',
      NULL,
      18,
      34.123050,
      NULL,
      37.651333,
      98,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      6,
      5.657083,
      1,
      2,
      11,
      '10- 2-2002',
      1.186243,
      0,
      69.761534,
      1,
      2.719043,
      NULL,
      0.558038,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 4-1976',
      30,
      NULL,
      58,
      102,
      86,
      22,
      30,
      0.164909,
      103.809997,
      NULL,
      64.838320,
      90,
      '11-11-1983',
      18,
      1,
      3,
      0,
      36.675366,
      NULL,
      0.834265,
      ' 0- 2-1982',
      NULL,
      11.857535,
      ' 5- 7-1985',
      4,
      4,
      17,
      14,
      1.975871,
      NULL,
      1.706105,
      14.027488,
      NULL,
      2,
      2.697051,
      0.202291,
      NULL,
      18.101312,
      2,
      4.197922,
      1,
      0.155893,
      ' 5- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      140,
      1.293575,
      ' 4-18-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-26-1993',
      7,
      1.944349,
      NULL,
      67,
      53.379171,
      ' 5-11-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      ' 6- 6-1999',
      64,
      24,
      8,
      ' 2-25-1992',
      1,
      44,
      ' 3- 9-2000',
      8.503785,
      1,
      20.232890,
      49,
      ' 2-26-2002',
      NULL,
      1,
      53,
      '11-29-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


