set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9028833';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4032',
      '00434321',
      NULL,
      '10430441',
      '41034441',
      '43313111',
      NULL,
      '43430141',
      '14233234',
      '10104401',
      '00441403',
      '20113311',
      '12004333',
      '32144203',
      '04302142',
      '23331024',
      '00000431',
      '31041114',
      '13412130',
      '10232333',
      '23120214',
      '33400114',
      '00011424',
      '04114120',
      NULL,
      '00341040',
      '40243030',
      '14420223',
      '23120440',
      '04214303',
      '44402003',
      '34031401',
      '12041044',
      '23030224',
      '04413411',
      NULL,
      '14414334',
      '22122340',
      '32240324',
      '00432342',
      '41334023',
      '42401044',
      '34020123',
      '22220122',
      '33422044',
      '',
      '',
      NULL,
      NULL,
      '1241131',
      NULL,
      0.700975,
      1,
      NULL,
      '222242',
      3,
      ' 5-25-1990',
      ' 6-25-1990',
      23.765965,
      NULL,
      2,
      NULL,
      36.468953,
      NULL,
      NULL,
      19,
      11.837791,
      3,
      NULL,
      31.377199,
      6.102485,
      26.562126,
      18.035037,
      NULL,
      1,
      14,
      NULL,
      4.733676,
      NULL,
      NULL,
      101.533969,
      8.464971,
      NULL,
      NULL,
      114,
      46,
      NULL,
      204.587461,
      80.837687,
      ' 8-28-1993',
      NULL,
      NULL,
      29.106387,
      28.796468,
      NULL,
      28.642426,
      ' 7-27-1994',
      NULL,
      1.211438,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.303251,
      1.670890,
      0,
      1.984765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-23-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      153.712944,
      148,
      NULL,
      11,
      133,
      73,
      69.149456,
      71,
      90,
      30.651490,
      NULL,
      123,
      ' 9-15-1994',
      14.103513,
      17,
      31,
      95,
      2,
      30,
      10.078144,
      '11-19-2003',
      NULL,
      4,
      ' 7-21-2002',
      12,
      8.008666,
      NULL,
      NULL,
      1.454477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-15-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.697114,
      32,
      39.609565,
      '11- 3-1996',
      1.125590,
      97,
      NULL,
      13,
      23,
      9,
      23,
      ' 9-26-1999',
      7.177515,
      1.410989,
      114.282651,
      ' 1- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      0.379968,
      51,
      NULL,
      NULL,
      132.259165,
      NULL,
      5,
      19.140695,
      1.600292,
      1.663720,
      NULL,
      0,
      0,
      49,
      NULL,
      1.438894,
      37.067036,
      0,
      0.782180,
      34,
      0.486145,
      0.989245,
      24,
      NULL,
      4.458906,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0.483885,
      1.560654,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      1,
      0.715989,
      25.426930,
      1.245282,
      NULL,
      0,
      2.575911,
      1,
      NULL,
      0,
      NULL,
      1.959257,
      0,
      NULL,
      NULL,
      1.718882,
      NULL,
      NULL,
      NULL,
      19.861391,
      NULL,
      6.396144,
      3,
      0.802331,
      0.108043,
      0.832353,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 1-12-1996',
      NULL,
      ' 3-23-1991',
      ' 6-24-1975',
      NULL,
      NULL);
commit;
end;
/


