set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1011',
      '21210110',
      '41021133',
      '04112042',
      '04411111',
      NULL,
      '13444301',
      '43022111',
      '42443220',
      '13232231',
      '13031100',
      '01331333',
      '04012220',
      NULL,
      NULL,
      NULL,
      '43144033',
      '02413222',
      '43421100',
      '44423112',
      '33140342',
      '21114014',
      '32040002',
      '03124022',
      '00123022',
      '13333310',
      '23344310',
      '24334144',
      '31322442',
      '33424410',
      '44303100',
      NULL,
      '32324020',
      '24231342',
      '43204433',
      '04440123',
      '22342403',
      NULL,
      '13124232',
      '01331100',
      '02432322',
      '31443023',
      NULL,
      NULL,
      '13324414',
      '',
      '',
      NULL,
      NULL,
      '3013202',
      NULL,
      NULL,
      1,
      NULL,
      '112224',
      3,
      ' 6- 6-1977',
      ' 3-17-1999',
      NULL,
      NULL,
      19,
      10.944018,
      NULL,
      9.432479,
      NULL,
      15,
      NULL,
      8.161337,
      25,
      7.214581,
      29.535646,
      NULL,
      20.347232,
      16,
      18,
      4,
      1.807654,
      2.562076,
      52.107986,
      0,
      31.596570,
      14,
      NULL,
      67.667846,
      114,
      8,
      12.449746,
      178.317328,
      NULL,
      ' 2- 0-1996',
      2.533512,
      NULL,
      NULL,
      19.764101,
      32,
      NULL,
      ' 3-11-1977',
      1.769046,
      1,
      4.283533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886075,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-13-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-21-1997',
      NULL,
      75.085245,
      29.002053,
      114,
      NULL,
      72,
      NULL,
      89,
      4,
      74,
      2,
      38.867410,
      ' 8-19-1991',
      3,
      15,
      20,
      21,
      79.028930,
      111.710981,
      9.224400,
      ' 4- 9-1985',
      29.306418,
      9.549040,
      '11- 6-2001',
      7,
      3.310768,
      NULL,
      14.616052,
      20.888093,
      10.813466,
      NULL,
      9,
      NULL,
      98.481395,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.581758,
      21,
      14,
      '10-21-1991',
      NULL,
      120,
      ' 4-19-1990',
      3.619223,
      14,
      10.202300,
      NULL,
      ' 6- 9-1987',
      NULL,
      0.970984,
      95.812534,
      NULL,
      NULL,
      NULL,
      NULL,
      63.584211,
      1.509978,
      0,
      47,
      15.320706,
      NULL,
      NULL,
      3,
      2,
      NULL,
      9.258572,
      49,
      0,
      3.217484,
      NULL,
      2.438257,
      3,
      36,
      0.664371,
      2.751142,
      28.664923,
      1,
      0,
      38,
      51.426689,
      21.239697,
      67.978219,
      0.116883,
      22.127458,
      0.561699,
      1,
      1,
      1,
      1.811276,
      0,
      NULL,
      55,
      8.921524,
      NULL,
      46.172614,
      39.161718,
      2,
      NULL,
      NULL,
      NULL,
      8.324614,
      8,
      NULL,
      0,
      41,
      1.515223,
      5.454777,
      0.482877,
      0,
      74,
      16.068401,
      5,
      NULL,
      NULL,
      20,
      14.533885,
      61,
      5,
      1,
      1,
      NULL,
      0.059332,
      1,
      1.582423,
      0.178861,
      29,
      ' 1-23-1989',
      ' 3-10-1988',
      ' 7-14-1978',
      ' 8- 9-1988',
      ' 1-26-2001',
      ' 6-27-1998',
      ' 2-18-2003',
      NULL);
commit;
end;
/


