set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2041',
      '24404043',
      '42232314',
      NULL,
      '11300112',
      '24221110',
      '03210420',
      '21240332',
      NULL,
      NULL,
      '44024023',
      '20324243',
      NULL,
      NULL,
      NULL,
      '42422301',
      '03142000',
      '01413324',
      '04030040',
      NULL,
      '42412033',
      '12320322',
      '41424040',
      NULL,
      '12414243',
      '24241413',
      '21333133',
      '03140203',
      '33104334',
      '44421243',
      NULL,
      '31144342',
      '21303223',
      '20040412',
      '20201303',
      '11043242',
      '30004014',
      '41034231',
      '42033132',
      NULL,
      '03114342',
      '41211020',
      '03434322',
      '12320123',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '0433102',
      2.511183,
      24,
      2,
      NULL,
      '211004',
      1.688167,
      NULL,
      '11-28-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.134016,
      14.913284,
      19.403565,
      3.262451,
      NULL,
      133,
      '10- 6-1982',
      2.477574,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792208,
      0,
      0.989321,
      1.780744,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-27-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1980',
      97,
      49.997493,
      94,
      20.641156,
      65.778723,
      85.006913,
      56.384497,
      20.281364,
      38.767066,
      49.021663,
      46,
      62,
      NULL,
      7.109630,
      7.425249,
      14.833868,
      30.944713,
      15,
      52.821505,
      4,
      ' 5-20-1999',
      6.680160,
      9.087237,
      ' 3- 6-1982',
      NULL,
      2,
      9,
      NULL,
      NULL,
      1.466636,
      NULL,
      NULL,
      NULL,
      86.028300,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.630436,
      ' 6-19-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.310935,
      1.629236,
      1,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.359074,
      1.424716,
      0.687616,
      NULL,
      19.271296,
      NULL,
      0,
      102.994335,
      3,
      3,
      NULL,
      58.570145,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.448629,
      NULL,
      NULL,
      NULL,
      89,
      2,
      6,
      NULL,
      0.086856,
      NULL,
      NULL,
      0,
      3.319135,
      NULL,
      0.487358,
      NULL,
      1,
      0,
      NULL,
      9.464922,
      1,
      25,
      8.650810,
      NULL,
      NULL,
      NULL,
      9.633894,
      0.405129,
      1,
      1.016877,
      1.640332,
      1.596460,
      1.615268,
      0,
      20.339004,
      NULL,
      NULL,
      NULL,
      ' 8- 4-1987',
      ' 4-14-2002',
      NULL,
      NULL,
      NULL);
commit;
end;
/


