set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '44024330',
      '42432242',
      '44421442',
      '20311412',
      '44312201',
      '01023311',
      '11331244',
      '12342300',
      '44304214',
      '23132423',
      '22202410',
      '41342200',
      '33422002',
      NULL,
      '13040413',
      '12043003',
      NULL,
      NULL,
      '11110322',
      '13023414',
      '03000233',
      '10321330',
      '24342033',
      '04212430',
      '02133242',
      '04124101',
      '10014241',
      '24303143',
      '01313312',
      '32103233',
      '30240410',
      '24240404',
      '30413443',
      '13042313',
      '12024113',
      '13121032',
      '00410300',
      '12332103',
      '44241223',
      '11340044',
      NULL,
      '43303103',
      '04033200',
      '340',
      NULL,
      10,
      7,
      '4034334',
      0,
      NULL,
      NULL,
      NULL,
      '043103',
      1.600580,
      ' 9- 1-2003',
      ' 5- 1-1991',
      55,
      87,
      NULL,
      NULL,
      12,
      10,
      57,
      8.606181,
      7.834116,
      NULL,
      15.205296,
      5.954303,
      21.914579,
      16,
      NULL,
      0,
      5.952482,
      NULL,
      NULL,
      1,
      17,
      NULL,
      34,
      NULL,
      1,
      NULL,
      60,
      15.979628,
      58.869193,
      139,
      NULL,
      ' 7-12-1980',
      47,
      21,
      35.788307,
      6.262730,
      NULL,
      110.082003,
      ' 5-15-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.052714,
      NULL,
      6.268986,
      6,
      NULL,
      NULL,
      ' 3-27-1976',
      1.745577,
      NULL,
      120.449521,
      0,
      0,
      121,
      2,
      2.294059,
      54.838880,
      NULL,
      NULL,
      NULL,
      NULL,
      64.989529,
      23.157591,
      31,
      NULL,
      NULL,
      7,
      55,
      54,
      32.923674,
      46.667341,
      NULL,
      35,
      ' 8-28-1991',
      37.275916,
      2,
      20,
      6,
      NULL,
      150.427594,
      NULL,
      ' 5-23-1998',
      9.304217,
      0,
      ' 6- 3-1978',
      3,
      NULL,
      13,
      2,
      12.735777,
      3,
      1.755147,
      NULL,
      0.177863,
      50,
      3,
      0,
      1,
      5,
      6.527566,
      NULL,
      0.336510,
      0,
      ' 0-22-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      32.757678,
      ' 3-16-1984',
      NULL,
      ' 9-22-2001',
      10.440174,
      12,
      '10-21-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      12,
      ' 0-14-1976',
      NULL,
      8,
      NULL,
      ' 5-18-1996',
      0,
      77.496937,
      '11-11-1974',
      2,
      45.649832,
      23.868798,
      48.232489,
      ' 3-11-1984',
      27,
      1,
      194,
      ' 9-22-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


