set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '2',
      NULL,
      '2',
      NULL,
      '0',
      '4',
      '0',
      '4',
      '1',
      '3',
      '1',
      '2',
      '1',
      '3',
      '1',
      '2',
      '3',
      '2',
      '4',
      NULL,
      '4',
      NULL,
      '',
      '1',
      '',
      '4',
      NULL,
      '1',
      '4',
      '1',
      '',
      '',
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      '1',
      '1',
      '404',
      '40043020',
      42.317881,
      27.938778,
      '3213330',
      2.886731,
      23,
      NULL,
      NULL,
      '433402',
      4.853598,
      NULL,
      ' 4- 7-1983',
      42.951471,
      8,
      42.472961,
      6.333275,
      16.187514,
      12.858870,
      25,
      14,
      2,
      11,
      22,
      4,
      25,
      11.348634,
      11,
      14.361377,
      33.017319,
      13,
      47,
      13.076396,
      67,
      8,
      66,
      8.342746,
      0,
      102,
      97,
      1.919319,
      NULL,
      95,
      10,
      ' 8- 4-1986',
      6,
      31.526222,
      21,
      0,
      NULL,
      10,
      '11- 3-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.871945,
      NULL,
      12.750223,
      10,
      15.942152,
      3.295870,
      ' 7-20-1990',
      0.034232,
      0,
      7,
      0.138614,
      1,
      154.100956,
      0.687685,
      1.606437,
      25.380636,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1979',
      72.691939,
      69.869719,
      NULL,
      14.300783,
      60,
      64,
      42,
      61,
      17.595799,
      51,
      9.668290,
      40.220228,
      ' 6-12-1994',
      NULL,
      6.539445,
      6.103886,
      6.043744,
      56.019889,
      40,
      3,
      ' 3-22-1986',
      29,
      11.304263,
      NULL,
      0,
      NULL,
      12,
      6.965917,
      7,
      NULL,
      NULL,
      9,
      1,
      55.041486,
      4,
      0,
      4,
      NULL,
      5,
      3.390121,
      1,
      1,
      '10-17-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      224,
      6,
      ' 9-24-1980',
      NULL,
      NULL,
      NULL,
      31,
      ' 1-24-2002',
      41,
      NULL,
      NULL,
      13.778404,
      ' 6- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      ' 4- 9-2001',
      45,
      50.332639,
      57,
      NULL,
      1.283640,
      68,
      ' 7-18-1981',
      NULL,
      2,
      21.094652,
      39.349710,
      ' 4-13-1979',
      53,
      0.897730,
      86,
      ' 3- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


