set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '2',
      '4',
      '1',
      '4',
      '0',
      '1',
      '0',
      '1',
      '4',
      '0',
      '1',
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      '3',
      NULL,
      '4',
      '0',
      '3',
      '0',
      NULL,
      '1',
      NULL,
      '4',
      '3',
      '0',
      '1',
      '4',
      '',
      '',
      '4',
      NULL,
      NULL,
      '0',
      '0',
      '0',
      '2',
      '1',
      '4',
      '0',
      '4',
      '404',
      '42334320',
      10.726585,
      52,
      '3201143',
      3.478311,
      277.317236,
      0,
      1,
      NULL,
      4,
      ' 6-16-2001',
      NULL,
      NULL,
      107.124915,
      11.831310,
      19.712458,
      NULL,
      1.010409,
      NULL,
      0.247938,
      NULL,
      NULL,
      NULL,
      4,
      34.132987,
      2.431903,
      3.897458,
      21.870359,
      2.273113,
      NULL,
      NULL,
      14,
      64,
      15.172543,
      2.552590,
      7,
      NULL,
      24.878817,
      118,
      NULL,
      NULL,
      15.852254,
      57,
      ' 7- 8-1990',
      41.204512,
      35,
      NULL,
      22.203640,
      24,
      NULL,
      ' 8- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54.317377,
      10,
      NULL,
      2.278182,
      51,
      1.958874,
      ' 1- 7-1974',
      1,
      1,
      139.457025,
      NULL,
      4.514087,
      35.071420,
      0.601607,
      1.002968,
      54,
      NULL,
      NULL,
      NULL,
      ' 5- 0-1992',
      5.799463,
      10.900502,
      60,
      4,
      26,
      30.346633,
      27.090013,
      31.419275,
      NULL,
      51,
      59.100122,
      54.120806,
      ' 5-15-1974',
      10.180905,
      7,
      3.588232,
      NULL,
      35,
      4,
      4.109194,
      NULL,
      19.949909,
      7,
      ' 3-17-1983',
      9,
      9.699245,
      10.822936,
      16.338494,
      10,
      0,
      0.285186,
      7,
      NULL,
      NULL,
      6.575959,
      2.646980,
      1.822693,
      NULL,
      1.049202,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      176.894550,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      '10-10-1980',
      5,
      ' 1- 3-1987',
      NULL,
      12.434442,
      ' 2-19-1987',
      138,
      65,
      ' 7-20-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      13.529830,
      ' 7-27-1978',
      NULL,
      13.241455,
      NULL,
      ' 1- 7-1995',
      0.556469,
      13.924963,
      ' 7-13-1989',
      4.713591,
      NULL,
      17.993737,
      10,
      ' 3- 1-1983',
      16.673803,
      0,
      48.459212,
      '10- 7-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


