set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4332',
      '22013420',
      '23423121',
      '14232133',
      '24243014',
      NULL,
      '40322003',
      NULL,
      '12100221',
      '42404410',
      '30010121',
      '41324411',
      '12443014',
      NULL,
      '04233143',
      NULL,
      '00440333',
      '12231022',
      '11033424',
      '31123024',
      '31034442',
      '20224141',
      NULL,
      '10002120',
      NULL,
      NULL,
      '01400100',
      '31041141',
      NULL,
      '12214422',
      '21210110',
      '21302043',
      '34212412',
      '14412341',
      NULL,
      '33430243',
      '14120041',
      '02440212',
      '43421441',
      NULL,
      NULL,
      '30214244',
      NULL,
      '34123140',
      NULL,
      '014',
      '32',
      NULL,
      NULL,
      '0422102',
      5.198036,
      1,
      NULL,
      NULL,
      '413131',
      NULL,
      ' 7-25-1980',
      ' 9-14-1999',
      75.299255,
      NULL,
      6.064158,
      NULL,
      5.826582,
      0.631304,
      38,
      3.450948,
      0,
      NULL,
      28,
      6,
      40.792334,
      9,
      28.448203,
      8,
      12.870409,
      12,
      NULL,
      NULL,
      26.763310,
      NULL,
      52,
      3,
      1,
      NULL,
      120.376044,
      96.441515,
      178,
      NULL,
      140.220481,
      ' 2- 1-1992',
      56.132273,
      NULL,
      10.245992,
      31,
      NULL,
      61.802555,
      ' 3-19-1978',
      3.477717,
      0.670275,
      1,
      0.971999,
      0.349312,
      NULL,
      NULL,
      2,
      0.573685,
      1,
      0,
      NULL,
      1.303256,
      3.056324,
      0.237589,
      0,
      1.909071,
      1,
      1.037999,
      0.434174,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1986',
      17.528134,
      12.903243,
      16,
      16,
      15,
      3.746143,
      ' 0-12-1999',
      NULL,
      NULL,
      121.954313,
      0,
      NULL,
      120.120726,
      NULL,
      1,
      40.911116,
      NULL,
      NULL,
      NULL,
      ' 9-26-1989',
      89.750313,
      98.294838,
      65,
      4,
      46.741031,
      29.478767,
      46.452165,
      NULL,
      77,
      53.524126,
      6,
      12,
      ' 4- 2-1986',
      26.201502,
      16,
      NULL,
      92.943395,
      NULL,
      91.599962,
      NULL,
      NULL,
      3,
      3.563244,
      ' 7-22-1990',
      2.149855,
      14,
      19,
      28.755117,
      NULL,
      5,
      NULL,
      5.766956,
      1,
      114,
      NULL,
      1.274835,
      4.212957,
      15,
      1.726861,
      0.576934,
      1,
      NULL,
      '11-12-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      106,
      3.318955,
      '11-14-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-2001',
      29,
      ' 3- 1-1988',
      6,
      NULL,
      ' 0- 4-2003',
      17,
      10,
      '11- 9-2003',
      4,
      0.968993,
      ' 1-18-2000',
      NULL,
      NULL,
      NULL,
      1,
      1,
      8,
      NULL,
      41.589949,
      NULL,
      40.476243,
      ' 0-21-1982',
      6,
      101.152039,
      ' 1-16-1975',
      17,
      38,
      1.557740,
      33.209268,
      ' 4-24-1985',
      2.677492,
      1.680238,
      151,
      '10-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


