set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9887125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '3',
      '4',
      '0',
      '2',
      '3',
      '1',
      '3',
      '3',
      NULL,
      '4',
      '0',
      '1',
      '3',
      '2',
      '0',
      '0',
      '2',
      '1',
      '2',
      '1',
      '4',
      NULL,
      '',
      '2',
      NULL,
      NULL,
      '2',
      '0',
      '0',
      '1',
      '',
      '',
      '3',
      '4',
      NULL,
      NULL,
      '2',
      '2',
      '3',
      '2',
      NULL,
      NULL,
      '3',
      NULL,
      '32211140',
      28,
      NULL,
      '0303340',
      0,
      NULL,
      3,
      1,
      '022003',
      2,
      '10-22-1997',
      NULL,
      91.786783,
      NULL,
      1.570570,
      18,
      34,
      19,
      56.106887,
      12.003785,
      29.146890,
      19,
      26,
      4,
      38.586831,
      8.273904,
      NULL,
      NULL,
      29,
      NULL,
      54.238413,
      1,
      57,
      29.883407,
      93.347603,
      21.080950,
      1,
      1,
      164.571852,
      NULL,
      42.677816,
      259.126005,
      124.683823,
      ' 0-13-1997',
      8,
      18.961337,
      NULL,
      30.327672,
      34.872370,
      130.783975,
      ' 9- 4-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      11,
      NULL,
      0.128044,
      4,
      3.728621,
      ' 2-27-2003',
      NULL,
      0,
      226,
      1,
      2.115483,
      43.820736,
      1,
      NULL,
      79,
      NULL,
      NULL,
      NULL,
      ' 1- 7-1977',
      NULL,
      52.765608,
      NULL,
      40.805218,
      NULL,
      51,
      94.831962,
      48.306030,
      42,
      NULL,
      38.274312,
      78,
      '10-25-1986',
      30.025433,
      NULL,
      27.331304,
      70.201108,
      51.335156,
      10.787940,
      8,
      ' 1- 1-1992',
      21,
      NULL,
      ' 0-17-1984',
      6.292821,
      6,
      28,
      27,
      NULL,
      1,
      1,
      17.410955,
      1,
      114.715882,
      3,
      1,
      24,
      14.304427,
      1,
      NULL,
      0.709013,
      NULL,
      ' 3-25-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      28.131736,
      NULL,
      13,
      ' 9-10-1978',
      3.593975,
      0.838159,
      NULL,
      100,
      106,
      ' 8-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.542668,
      ' 4- 4-1982',
      37,
      44.535186,
      35.758235,
      '11-25-1985',
      0.096047,
      93,
      ' 8-26-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


