set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1302',
      '10433402',
      '24440241',
      NULL,
      '00314114',
      '10110131',
      '33114211',
      '30234144',
      NULL,
      '44332232',
      '10420201',
      '30134022',
      '02403230',
      '42012213',
      '20410002',
      '11440210',
      NULL,
      NULL,
      '23312312',
      NULL,
      '00014310',
      '30331203',
      '31344301',
      '02244223',
      '11013313',
      '01310130',
      '24013444',
      '22212434',
      '41432031',
      '23233424',
      '34043112',
      '30443442',
      '01310210',
      '43024111',
      '23341144',
      '41144123',
      '44033220',
      '43334344',
      NULL,
      '44420404',
      '40141021',
      '20233312',
      '00411202',
      '41004021',
      NULL,
      '003',
      '14',
      NULL,
      NULL,
      '0043311',
      2.709169,
      1,
      3,
      NULL,
      '431443',
      1,
      ' 0- 7-1984',
      ' 6-17-1975',
      21,
      NULL,
      28,
      18,
      4,
      1.245771,
      4.041377,
      16,
      5.501439,
      3.510225,
      52.275506,
      33,
      38.227611,
      NULL,
      26.667989,
      1,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      3,
      35.056830,
      1,
      NULL,
      NULL,
      140,
      85,
      153.230032,
      257,
      61,
      NULL,
      60,
      63,
      19.237095,
      NULL,
      208.487171,
      90.870956,
      NULL,
      NULL,
      1.956932,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1.713256,
      1,
      1,
      0,
      0.917434,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-15-1998',
      98,
      2.465855,
      4.612572,
      0,
      2.270316,
      4,
      NULL,
      1.965754,
      0,
      NULL,
      NULL,
      0,
      88,
      2.633278,
      3,
      NULL,
      1.484675,
      NULL,
      161,
      ' 9-20-1983',
      10,
      17.092936,
      31,
      9.059028,
      90.172206,
      34.484571,
      84,
      61,
      84,
      47,
      74.515228,
      6,
      NULL,
      21,
      NULL,
      14.447690,
      25.271307,
      NULL,
      89,
      1.289905,
      ' 6-10-1988',
      16.815181,
      NULL,
      ' 9-24-1988',
      7.754308,
      20,
      4.359022,
      8,
      24,
      15,
      0,
      NULL,
      1,
      74.409220,
      2.826749,
      3.154774,
      9,
      20.254288,
      2,
      1,
      1.130256,
      NULL,
      NULL,
      1.501547,
      3,
      6,
      NULL,
      225,
      1,
      NULL,
      18,
      5.096127,
      ' 7- 5-1990',
      35,
      ' 6- 7-2003',
      9.219851,
      ' 0-18-1981',
      NULL,
      NULL,
      ' 7- 0-1986',
      40,
      25.896887,
      ' 8-27-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      1.200224,
      NULL,
      1,
      1,
      18.103364,
      ' 3-23-1983',
      18.709894,
      27,
      12.519879,
      ' 3-14-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


