set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8421847';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03222403',
      NULL,
      '03000143',
      NULL,
      '32233423',
      '11040131',
      '44203031',
      NULL,
      '23011312',
      '44002100',
      '13123233',
      '32102031',
      NULL,
      '10441014',
      '23040242',
      '44332140',
      '13033334',
      NULL,
      '03142410',
      '21033023',
      '30020120',
      '41204403',
      '14210330',
      NULL,
      NULL,
      '23321402',
      '44002131',
      '11101022',
      '33442434',
      '34140213',
      '41320020',
      '32014041',
      NULL,
      '22324334',
      NULL,
      '10234430',
      '44003420',
      '33411300',
      NULL,
      '23324411',
      '21421031',
      '03022401',
      '22243243',
      '30024443',
      '244',
      '02',
      NULL,
      NULL,
      '1131411',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.326763,
      '11- 8-1981',
      ' 7-22-1995',
      NULL,
      NULL,
      5.051626,
      5.084642,
      31,
      5,
      NULL,
      16,
      11,
      9,
      9,
      5.811900,
      40,
      18.368859,
      6,
      14,
      15,
      2,
      NULL,
      16,
      29.557545,
      18.781106,
      31,
      6,
      1,
      68.796168,
      7.491870,
      76.594520,
      NULL,
      131.143549,
      154,
      ' 9- 7-1980',
      13,
      34.021150,
      13.938670,
      NULL,
      127,
      177,
      ' 4-18-1992',
      0.963358,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      2,
      1,
      0.694192,
      NULL,
      3.556759,
      1,
      5.613926,
      0.474222,
      NULL,
      1,
      1.819753,
      0,
      1.629782,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-24-1993',
      NULL,
      NULL,
      12.318105,
      16,
      8,
      8.152767,
      ' 2- 2-1986',
      0.327423,
      2.446425,
      76,
      0,
      NULL,
      78,
      1.373471,
      1.109281,
      NULL,
      NULL,
      0.855369,
      130.660149,
      ' 9-11-2001',
      46.801715,
      17,
      9.029453,
      21,
      38.622911,
      59.108430,
      36,
      6,
      1.296321,
      41,
      0.107453,
      45,
      ' 6-24-1983',
      35.695499,
      9,
      27.441927,
      NULL,
      NULL,
      147,
      4,
      ' 0-18-1982',
      14.589641,
      NULL,
      '11- 9-1989',
      5,
      1,
      NULL,
      NULL,
      29.177301,
      11,
      1,
      27.960202,
      NULL,
      NULL,
      2.129402,
      NULL,
      12.822447,
      NULL,
      0.555347,
      0,
      NULL,
      1.272874,
      NULL,
      NULL,
      NULL,
      5.597404,
      ' 0-28-1988',
      18,
      27.141080,
      ' 2-28-1998',
      NULL,
      NULL,
      NULL,
      30,
      ' 4-22-1993',
      20,
      ' 8-28-1975',
      7.841182,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587393,
      NULL,
      ' 2-27-1996',
      0,
      11.032930,
      ' 0-20-1977',
      NULL,
      0,
      9,
      '11-28-1982',
      46,
      12.366535,
      24,
      '10-27-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


