set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1111',
      NULL,
      NULL,
      '12141002',
      NULL,
      NULL,
      '24442022',
      '42101241',
      NULL,
      '30204332',
      NULL,
      '21002443',
      NULL,
      '21442003',
      '24342403',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44424131',
      NULL,
      '23332113',
      '40231111',
      '32013441',
      '34122421',
      '34311143',
      '33200333',
      NULL,
      '04300240',
      NULL,
      '33132110',
      '23444304',
      '11340423',
      '04202443',
      '03043200',
      NULL,
      '40213442',
      '04133132',
      '22312114',
      '32440110',
      '20414012',
      '20304124',
      '04224021',
      NULL,
      '324',
      '10',
      NULL,
      NULL,
      '1334422',
      NULL,
      0.192496,
      2,
      NULL,
      '200333',
      0,
      ' 0-24-1992',
      ' 1-11-2001',
      3,
      NULL,
      8.790253,
      2.447297,
      7.541623,
      8,
      12.044942,
      15.150840,
      4,
      12,
      9.309964,
      3,
      28.494547,
      NULL,
      1,
      7.853671,
      NULL,
      NULL,
      36,
      NULL,
      NULL,
      4.020908,
      80.998536,
      10,
      1,
      3,
      75,
      22.808306,
      125.060429,
      153.807597,
      80.099166,
      ' 2-13-1999',
      13,
      49.740284,
      5,
      11,
      108,
      41,
      '10-18-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      39.667929,
      31,
      NULL,
      17.699942,
      0,
      ' 1- 0-1998',
      0,
      NULL,
      116.553974,
      1,
      NULL,
      4.389993,
      1.405765,
      1,
      62,
      NULL,
      NULL,
      NULL,
      ' 3-23-1974',
      42.806609,
      100,
      65,
      77,
      NULL,
      66,
      1,
      NULL,
      42.504556,
      54.316764,
      62,
      113.078178,
      ' 3-29-1996',
      12.536420,
      NULL,
      17.423384,
      35,
      4.080241,
      NULL,
      1.813809,
      ' 5-19-1992',
      7,
      2,
      ' 7-26-1994',
      9,
      NULL,
      NULL,
      4.152059,
      5.520054,
      1.195318,
      0,
      15,
      0.974946,
      51,
      0.015561,
      6,
      18.205172,
      NULL,
      1,
      1.143811,
      NULL,
      1.521664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.556067,
      7.771066,
      ' 0-26-1978',
      NULL,
      NULL,
      NULL,
      24.738283,
      ' 4- 2-1988',
      15.549590,
      ' 4-11-1992',
      NULL,
      15.334638,
      ' 8-26-1985',
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      ' 1-20-1979',
      NULL,
      NULL,
      NULL,
      2,
      1,
      13.001530,
      ' 0-14-1978',
      19,
      14.603517,
      13,
      ' 4-14-1995',
      1,
      57.074848,
      ' 2- 2-2000',
      NULL,
      48.749026,
      1.790590,
      55,
      ' 7- 9-1989',
      47.166824,
      1.662171,
      182.905800,
      '10-15-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


