set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1430',
      '02142434',
      '10201431',
      '14043011',
      '40243024',
      '11021330',
      '02004313',
      '03141234',
      NULL,
      '30201021',
      NULL,
      '23220201',
      '01210102',
      '30233313',
      '03203001',
      '10241112',
      NULL,
      '20301300',
      NULL,
      '21300043',
      '21431041',
      '21020442',
      '01124404',
      '30234204',
      '02430224',
      '42121404',
      '44400043',
      '40414311',
      '44334210',
      '02240330',
      NULL,
      '34042222',
      '23202021',
      '23022011',
      NULL,
      '03204144',
      NULL,
      '01223440',
      '00220043',
      '24313042',
      NULL,
      NULL,
      NULL,
      '42030210',
      '42220312',
      '220',
      '30',
      45,
      11.664824,
      '4310224',
      NULL,
      45.849870,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-13-1997',
      41.735047,
      140.311687,
      24.438614,
      9.159723,
      14,
      8,
      NULL,
      5.153593,
      10,
      1,
      7,
      0.700041,
      NULL,
      3.245492,
      24,
      15,
      19.412523,
      10,
      58,
      8,
      57.181668,
      NULL,
      53.032699,
      3,
      1,
      35,
      161.178432,
      7.093056,
      NULL,
      4.622481,
      66,
      ' 1-12-1974',
      13.305056,
      27,
      NULL,
      2.543105,
      73,
      83,
      ' 3-21-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.773968,
      16.531199,
      3,
      18.040732,
      18.878946,
      NULL,
      '11-13-1983',
      0,
      1.800127,
      NULL,
      1,
      1.669644,
      14,
      0.955617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-1979',
      37.317291,
      87.459735,
      34.429748,
      31.193179,
      NULL,
      25,
      8.871822,
      96.576785,
      64.944565,
      10,
      15,
      42,
      '11-15-1977',
      13.237352,
      4,
      1,
      21.161614,
      14,
      11,
      5,
      ' 8- 0-1975',
      14.710497,
      NULL,
      ' 7- 7-1993',
      1.139848,
      4,
      11,
      13,
      14.361050,
      6,
      1,
      1.661718,
      1.909818,
      65.897632,
      NULL,
      4.592533,
      19.204391,
      14,
      2,
      0,
      NULL,
      1.035153,
      '11-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      149,
      3,
      ' 7-27-1984',
      NULL,
      NULL,
      NULL,
      18,
      ' 8-29-1980',
      51,
      ' 9-17-1996',
      NULL,
      8.941851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      12,
      NULL,
      46.186466,
      21.815492,
      0.039474,
      NULL,
      0.586242,
      26.726442,
      ' 4- 1-1976',
      NULL,
      65,
      7.406270,
      10,
      ' 7-12-1977',
      58.774155,
      0.666917,
      22.956604,
      ' 4- 5-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


