set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      '2',
      '1',
      NULL,
      '2',
      '0',
      '4',
      '2',
      '4',
      '4',
      '0',
      '4',
      '4',
      '3',
      '1',
      '1',
      '4',
      '4',
      NULL,
      '3',
      '2',
      '1',
      NULL,
      '',
      '0',
      '',
      '1',
      '2',
      '3',
      '4',
      NULL,
      '',
      '',
      '4',
      '0',
      '1',
      '1',
      '1',
      '1',
      '1',
      '3',
      '1',
      NULL,
      NULL,
      '402',
      '04403012',
      45.429302,
      NULL,
      '3404014',
      3,
      0.565702,
      NULL,
      NULL,
      '341411',
      4,
      ' 7-21-1997',
      ' 8-10-1990',
      12.753806,
      147,
      32,
      9.199878,
      13.570993,
      6,
      NULL,
      3,
      18.718299,
      21.891687,
      NULL,
      13.897537,
      0,
      NULL,
      6,
      11.307440,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      10.305880,
      22.523867,
      NULL,
      1.707512,
      3.362016,
      3.201208,
      NULL,
      20,
      NULL,
      88.978489,
      ' 2-18-1991',
      12,
      54.728323,
      6.645368,
      NULL,
      204,
      167,
      ' 2-19-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.949667,
      32,
      22,
      27,
      NULL,
      0,
      '10-13-1976',
      0,
      3.736595,
      187.489933,
      0.294598,
      3.029583,
      NULL,
      0,
      0.356895,
      82.825279,
      NULL,
      NULL,
      NULL,
      ' 4- 0-1989',
      51,
      104.537466,
      46,
      NULL,
      46.631913,
      6,
      61,
      NULL,
      89.922815,
      63.913106,
      85,
      NULL,
      ' 1-17-1977',
      NULL,
      11,
      1.541784,
      NULL,
      27.927435,
      10.518778,
      5.358632,
      ' 1-19-1991',
      29,
      23.467504,
      ' 1-29-1986',
      10,
      4,
      7.395836,
      12,
      10.629551,
      7,
      1,
      8.319951,
      1,
      73,
      1.313205,
      NULL,
      10,
      9.821476,
      3,
      1,
      0.665186,
      NULL,
      '10-13-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      3,
      ' 8- 3-1978',
      NULL,
      NULL,
      NULL,
      0,
      ' 9-17-1995',
      NULL,
      ' 3-28-1982',
      NULL,
      7,
      ' 3-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      ' 1- 2-2003',
      48.112117,
      38,
      19.014246,
      NULL,
      5.473300,
      42,
      ' 8- 4-1988',
      7.266442,
      110.844799,
      10,
      1,
      ' 9-10-1976',
      44.748121,
      1,
      12,
      ' 5- 9-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


