set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '1',
      '2',
      '4',
      NULL,
      '2',
      '3',
      NULL,
      '4',
      '0',
      '4',
      NULL,
      '2',
      '1',
      '4',
      '1',
      '1',
      NULL,
      '4',
      '4',
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '0',
      '2',
      '2',
      '',
      '',
      '4',
      '3',
      '4',
      '0',
      '4',
      '4',
      '2',
      NULL,
      '1',
      '3',
      NULL,
      '232',
      '21442124',
      5.818609,
      0.427587,
      '2443142',
      NULL,
      196.235719,
      NULL,
      1,
      NULL,
      1,
      ' 5-13-2001',
      ' 1-10-1999',
      105.035812,
      10.247383,
      NULL,
      1.389940,
      NULL,
      NULL,
      35.697299,
      6,
      24,
      NULL,
      21.073427,
      13,
      47,
      24,
      24,
      2.374830,
      28.628686,
      20.660156,
      NULL,
      3,
      12.952058,
      0,
      54.376277,
      2.041804,
      0.926147,
      23.476206,
      111.180027,
      77.206813,
      137.633549,
      124.297912,
      21.067657,
      NULL,
      24.725517,
      41.615919,
      35,
      9.817675,
      NULL,
      26,
      ' 7-16-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      32,
      NULL,
      11,
      32.218895,
      0.889272,
      ' 9-13-2002',
      1,
      NULL,
      136.497738,
      1,
      0.889960,
      104,
      NULL,
      0.777646,
      42.548680,
      NULL,
      NULL,
      NULL,
      ' 2-20-1998',
      90.324693,
      3,
      70,
      60.706061,
      39,
      29,
      58,
      10,
      90.775322,
      14.384038,
      9,
      NULL,
      ' 6- 1-2001',
      9,
      1.280409,
      10.710392,
      16,
      NULL,
      4.322235,
      NULL,
      ' 7- 7-1987',
      11,
      0,
      ' 8-21-1983',
      1.358950,
      5.245830,
      7,
      7.637114,
      15.587390,
      7.922693,
      1,
      0,
      0.810706,
      82.098773,
      0,
      1.632909,
      12.519858,
      NULL,
      1,
      0.032507,
      NULL,
      0,
      ' 6- 5-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      46.334603,
      14,
      '10-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      ' 5-20-1991',
      1.025808,
      NULL,
      ' 5-17-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      NULL,
      28,
      NULL,
      ' 6-21-1979',
      0,
      46.350928,
      ' 8- 6-1974',
      9.747733,
      NULL,
      2.271436,
      NULL,
      NULL,
      4,
      0.620168,
      103,
      ' 3-16-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


