set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7214550';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1202',
      '23001400',
      NULL,
      NULL,
      '21001001',
      '44103224',
      '14412311',
      '44144233',
      '32211343',
      '01101003',
      NULL,
      '13010444',
      NULL,
      NULL,
      '10111304',
      '13040320',
      NULL,
      '33041334',
      '43324113',
      '24422410',
      '11302143',
      '43222414',
      NULL,
      '14323011',
      '21232133',
      '04332313',
      '01443213',
      NULL,
      '40003340',
      '23032433',
      NULL,
      '21143122',
      '13141240',
      '02220310',
      '01122333',
      '22133413',
      '31102204',
      NULL,
      '40144244',
      '44414320',
      '11144142',
      '03200334',
      '00020414',
      '40304304',
      '12414321',
      NULL,
      '02',
      35,
      37.352715,
      NULL,
      2,
      0.312264,
      0,
      NULL,
      NULL,
      NULL,
      ' 1-23-1975',
      ' 1-17-1990',
      NULL,
      220,
      4.525188,
      4.722209,
      9,
      2.637439,
      NULL,
      11.239771,
      8,
      NULL,
      NULL,
      13,
      23,
      11.780119,
      21,
      10,
      12.106083,
      15.952407,
      30,
      14,
      17.764277,
      17.515613,
      27,
      13.774104,
      NULL,
      104,
      86,
      NULL,
      154.505138,
      171,
      NULL,
      NULL,
      6,
      25.503782,
      17,
      2.398710,
      123.975549,
      113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      17,
      34,
      NULL,
      NULL,
      ' 5-13-1974',
      NULL,
      0.814716,
      33.990634,
      0,
      1,
      94,
      0,
      2,
      46,
      NULL,
      NULL,
      NULL,
      '11-22-1989',
      NULL,
      18.349019,
      NULL,
      52,
      NULL,
      85,
      NULL,
      26.078624,
      49,
      7,
      27.787609,
      75,
      ' 1- 0-1993',
      23,
      8.269784,
      9.305421,
      54,
      NULL,
      30,
      9,
      NULL,
      8,
      3,
      ' 2-25-1987',
      1,
      4,
      15,
      9.920671,
      8.194606,
      6.911053,
      0.459255,
      7,
      0.745885,
      NULL,
      0,
      1.006210,
      1.601195,
      8,
      4.110269,
      NULL,
      1.646316,
      NULL,
      ' 4- 2-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      28.689116,
      NULL,
      44.211051,
      ' 4-18-1999',
      12,
      12,
      '11- 8-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      20,
      ' 5- 9-1981',
      4.887036,
      4.663390,
      11.250352,
      ' 4- 0-1998',
      0,
      87,
      ' 1-14-2001',
      3,
      15.458226,
      3,
      12,
      ' 0-12-1992',
      NULL,
      0.934132,
      73,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


