set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7214550';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '3',
      NULL,
      '1',
      '3',
      '1',
      '4',
      NULL,
      '1',
      '0',
      '4',
      '3',
      '1',
      '2',
      '4',
      '2',
      NULL,
      '1',
      NULL,
      '1',
      '4',
      '3',
      '3',
      NULL,
      '2',
      '',
      '0',
      '2',
      '1',
      '0',
      '3',
      '',
      '',
      NULL,
      '2',
      '4',
      '2',
      '4',
      '4',
      '4',
      NULL,
      '4',
      '3',
      '2',
      '400',
      '21403044',
      5,
      51,
      '3032112',
      NULL,
      13.454202,
      NULL,
      NULL,
      '212021',
      4,
      ' 9-12-1992',
      ' 9- 0-1987',
      72,
      NULL,
      32,
      16,
      9,
      5.764008,
      20,
      10.707255,
      13.146653,
      12,
      25,
      10,
      5.063484,
      NULL,
      6,
      4.902976,
      NULL,
      NULL,
      31.828807,
      4.928915,
      NULL,
      0.217001,
      26,
      4,
      1.026668,
      3,
      5,
      35,
      138,
      NULL,
      90.179673,
      ' 5-22-1992',
      50,
      15,
      5,
      18.843046,
      131,
      173,
      ' 4-22-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      21.851336,
      34.174606,
      13,
      5,
      1.712862,
      ' 3-15-1992',
      1.222350,
      4,
      42,
      4.938387,
      2.405338,
      41,
      4,
      3,
      5.387115,
      NULL,
      NULL,
      NULL,
      ' 8- 7-1991',
      24,
      64.068767,
      59.705200,
      NULL,
      NULL,
      36,
      25.106092,
      35.296327,
      49,
      NULL,
      78,
      NULL,
      '11-23-1979',
      1.270505,
      NULL,
      16,
      16.961453,
      69.017594,
      NULL,
      6.785238,
      '11- 1-2001',
      1.550700,
      7,
      NULL,
      2.758120,
      NULL,
      10.508197,
      0.657571,
      10.201018,
      7,
      3.928815,
      0.650473,
      1.553586,
      41,
      1.959053,
      1.931888,
      3,
      11.296805,
      5.254743,
      NULL,
      NULL,
      NULL,
      ' 9-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      ' 3- 6-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      ' 7-20-2003',
      NULL,
      12.583953,
      ' 5-29-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      15.072535,
      ' 4- 5-1975',
      19,
      10.957378,
      18.073559,
      ' 2-26-1975',
      1.309264,
      26,
      ' 1- 4-1995',
      NULL,
      3.919716,
      11.833832,
      18,
      ' 4-18-1974',
      66.440648,
      1.662504,
      100,
      ' 3-11-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


