set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8724812';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4112',
      '24033411',
      '03421411',
      '34030001',
      '20224233',
      '21411430',
      '10033021',
      '12240112',
      NULL,
      '34142321',
      '12124141',
      '00223323',
      '04231311',
      '33444302',
      '10330111',
      NULL,
      '02400342',
      '24141310',
      '20221332',
      '41322303',
      NULL,
      '11323142',
      '20210110',
      '33232121',
      '11444340',
      '40202203',
      '30020302',
      '31120104',
      '20401404',
      NULL,
      NULL,
      NULL,
      NULL,
      '12332000',
      '32103130',
      '34203433',
      '13324302',
      '31310321',
      '31240010',
      '20402432',
      '22403013',
      '40402304',
      '21002142',
      '20033124',
      '03024242',
      '',
      NULL,
      NULL,
      NULL,
      '1442320',
      NULL,
      0,
      3,
      NULL,
      '131111',
      0,
      ' 3-12-1997',
      ' 2- 1-1983',
      NULL,
      NULL,
      20.325558,
      10.443566,
      3.079330,
      3,
      117,
      24,
      1.009089,
      18,
      45.857779,
      10,
      3,
      4,
      2.405704,
      0,
      0,
      15,
      64,
      19.038480,
      NULL,
      11,
      13.928475,
      22,
      NULL,
      70.150037,
      78,
      95,
      205.793170,
      242.716487,
      204,
      ' 5-11-1975',
      74.077730,
      72.808013,
      26,
      2.313637,
      140,
      NULL,
      NULL,
      2.747550,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-13-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      119,
      101.407209,
      29.890292,
      43,
      106.502292,
      21.755392,
      85.416958,
      46.633614,
      88,
      88,
      64,
      23,
      ' 5-27-1998',
      23,
      25.921219,
      1,
      NULL,
      NULL,
      32,
      9.992203,
      ' 7-24-1981',
      7.989687,
      16.896694,
      ' 2- 0-1981',
      7.019757,
      NULL,
      NULL,
      13,
      0.088666,
      11.570196,
      NULL,
      0.525019,
      NULL,
      92.142597,
      0.367001,
      NULL,
      7.846430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-14-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      36.254816,
      ' 3- 3-1999',
      1.085681,
      24,
      ' 4-22-1984',
      1.939057,
      NULL,
      9.477282,
      11.916222,
      ' 1-18-1980',
      65.689244,
      0.642187,
      NULL,
      ' 3- 4-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.260146,
      NULL,
      1,
      0.424308,
      6.625799,
      0,
      NULL,
      NULL,
      0,
      2.656033,
      186.240621,
      NULL,
      11.255925,
      NULL,
      NULL,
      NULL,
      0.571979,
      1,
      0.128335,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      13,
      1.846742,
      0,
      1,
      0,
      0,
      32.085405,
      0.287312,
      NULL,
      1,
      NULL,
      NULL,
      0.131733,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.610058,
      NULL,
      7.857373,
      3,
      0,
      1,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      ' 0-24-1990',
      NULL,
      ' 6-11-1985',
      ' 0-21-1975',
      ' 5- 1-1984',
      NULL,
      NULL);
commit;
end;
/


