set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501868';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43201010',
      '00010144',
      '13034402',
      NULL,
      NULL,
      '04443314',
      '14212242',
      '22203011',
      '30201434',
      '12041130',
      '41320142',
      '00442444',
      '14310442',
      '20442403',
      '42032240',
      '42201312',
      '42140014',
      '04100023',
      '41434203',
      '20342420',
      NULL,
      '33320413',
      '30402311',
      NULL,
      '41240032',
      '21340410',
      '30033341',
      NULL,
      '21042030',
      '42444433',
      '33140434',
      '40111134',
      '11444101',
      '13321143',
      '11340134',
      '02133230',
      '03110442',
      '33211223',
      '31112134',
      '12240023',
      '24433223',
      '14310304',
      '43141203',
      NULL,
      NULL,
      '03',
      NULL,
      NULL,
      '2421421',
      3.603796,
      0.516530,
      2,
      NULL,
      NULL,
      NULL,
      '11-22-1992',
      ' 7- 8-1986',
      120,
      NULL,
      40.922783,
      19.080678,
      17,
      3,
      NULL,
      19,
      NULL,
      18.603338,
      4.565192,
      10.192264,
      21,
      5,
      26,
      7.334255,
      25,
      20.905364,
      NULL,
      27,
      NULL,
      NULL,
      46.683537,
      3.461955,
      0,
      116,
      43,
      61.905053,
      14.561881,
      170,
      69,
      ' 3- 3-1977',
      61.333034,
      43.172031,
      32.607113,
      37,
      NULL,
      33,
      '11- 1-1977',
      3.452656,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      1,
      1,
      5,
      0,
      NULL,
      1,
      NULL,
      1.406586,
      2.950544,
      1.453846,
      0,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 7-1984',
      16.822487,
      9,
      9,
      9.744956,
      4,
      NULL,
      NULL,
      1,
      NULL,
      146,
      1.954520,
      2.836953,
      NULL,
      3.219550,
      1.252547,
      100.475373,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1996',
      39,
      NULL,
      87,
      0,
      79,
      47,
      NULL,
      NULL,
      104,
      89.410663,
      24.457967,
      NULL,
      ' 0-14-1977',
      28,
      NULL,
      NULL,
      NULL,
      5,
      70,
      7.441989,
      ' 6-22-1994',
      NULL,
      3,
      ' 6- 5-1994',
      3.177061,
      20,
      11.999617,
      NULL,
      NULL,
      11.574556,
      1,
      26.189442,
      1.899899,
      131,
      1,
      4.577743,
      NULL,
      4.928489,
      NULL,
      0,
      3,
      NULL,
      ' 2-20-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      4,
      '10-27-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-1996',
      39,
      '11-10-1984',
      NULL,
      2,
      ' 0-28-1992',
      101.601743,
      NULL,
      ' 2-29-2001',
      NULL,
      NULL,
      '11- 1-1981',
      NULL,
      NULL,
      NULL,
      2,
      3,
      9.522153,
      ' 8-14-1978',
      46,
      15.429529,
      NULL,
      ' 7-23-1990',
      0,
      45.894391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


