set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501868';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4123',
      '43210331',
      NULL,
      '31011412',
      NULL,
      '02401103',
      '44424033',
      NULL,
      '33320042',
      '44103102',
      '11100120',
      '22430043',
      '04323043',
      '03324233',
      '43042210',
      NULL,
      '33402224',
      '02024211',
      '20043343',
      '04024410',
      '42134121',
      '41003130',
      '14124023',
      NULL,
      '12134234',
      '34124404',
      '01302411',
      NULL,
      '04212123',
      NULL,
      NULL,
      '00023204',
      '01021110',
      NULL,
      '14421410',
      '34421110',
      NULL,
      '22124323',
      NULL,
      '30342343',
      NULL,
      '34112143',
      '14403012',
      '24031143',
      NULL,
      NULL,
      '33',
      12.603967,
      NULL,
      '4440031',
      NULL,
      10,
      3,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      50.547607,
      NULL,
      41.222452,
      23.298901,
      NULL,
      12.670722,
      80.826574,
      12,
      NULL,
      11,
      50,
      15,
      47,
      9.675136,
      38,
      5.545526,
      27.022163,
      NULL,
      78,
      11,
      NULL,
      3.614926,
      89,
      5.283549,
      0,
      NULL,
      NULL,
      12.432138,
      103.317785,
      171.819281,
      202.153834,
      ' 1-22-2001',
      49,
      NULL,
      16.716511,
      NULL,
      107,
      89,
      ' 1- 6-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      87.945202,
      11.742648,
      NULL,
      4.725551,
      8.527401,
      3.398690,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.050688,
      67,
      2,
      NULL,
      81,
      NULL,
      NULL,
      NULL,
      ' 4-18-1988',
      3,
      16.444475,
      95,
      19.226585,
      NULL,
      97,
      66.979800,
      NULL,
      13,
      35.880639,
      15.027901,
      NULL,
      NULL,
      3.380927,
      20,
      NULL,
      23.928257,
      52,
      5.980797,
      NULL,
      ' 4-26-1996',
      18,
      5,
      ' 9-17-1996',
      7.715829,
      1.936414,
      13,
      21.742381,
      19.203565,
      6.652022,
      1.189078,
      NULL,
      1.533935,
      80.840381,
      1,
      0.409408,
      7.320246,
      13,
      0.345348,
      1,
      1.027615,
      1.133381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      208.272098,
      NULL,
      ' 5-27-2001',
      NULL,
      NULL,
      NULL,
      30.218253,
      ' 6- 2-1993',
      20.638173,
      ' 0-24-1999',
      8,
      3,
      ' 6-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      24.420401,
      ' 7-20-1977',
      42,
      12.946830,
      21.497905,
      ' 5-19-1977',
      0,
      49,
      ' 9-26-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


