set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7728019';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0124',
      '33422132',
      '44342222',
      NULL,
      NULL,
      '41412333',
      '23011404',
      NULL,
      NULL,
      '13111301',
      '22201321',
      '41323403',
      '22142213',
      '30034430',
      '10022304',
      '01441432',
      '14321142',
      '02111033',
      NULL,
      '33121342',
      '44430441',
      '14144210',
      '13244103',
      '01121132',
      NULL,
      '23343034',
      '23232231',
      '21342124',
      '11102031',
      '32301213',
      '02432210',
      '20032020',
      '32002241',
      '04003103',
      '31323240',
      '01032312',
      '24342001',
      '32022310',
      '24343212',
      '00203101',
      NULL,
      '20140443',
      '03011101',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '2200344',
      2.762770,
      0.541791,
      0,
      NULL,
      '204234',
      2,
      ' 1- 3-1997',
      '10-10-1996',
      30.930783,
      NULL,
      NULL,
      NULL,
      NULL,
      12.575729,
      29.717876,
      23,
      26,
      25.639757,
      2,
      22.687778,
      2,
      NULL,
      1,
      14,
      19.797508,
      4,
      66,
      10.869666,
      51,
      10.356774,
      106.361055,
      4.032297,
      NULL,
      83.425481,
      152.591775,
      40,
      105,
      64,
      NULL,
      ' 6-22-1991',
      27.045985,
      NULL,
      7,
      1,
      136.319555,
      168,
      '11- 7-1978',
      1.282477,
      0.505363,
      0.984042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197974,
      1.548388,
      0.795629,
      1,
      0,
      0.087629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1988',
      107.380345,
      134,
      0,
      67,
      108.570028,
      74,
      13,
      80.043338,
      NULL,
      35,
      75,
      74.686203,
      ' 2-27-2001',
      12,
      17.598153,
      27.263860,
      79.927083,
      31.288419,
      17.737453,
      12,
      ' 0- 9-2000',
      8.284106,
      6,
      ' 4-15-1985',
      9.524786,
      2.227648,
      NULL,
      NULL,
      26,
      3.353165,
      NULL,
      0.098612,
      NULL,
      23,
      0.117065,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      38,
      NULL,
      '10-12-1997',
      0.808897,
      6,
      ' 9-28-1983',
      8.819771,
      5.760052,
      21.335223,
      30.024023,
      ' 7- 4-1989',
      8.468327,
      0.245424,
      68.178841,
      ' 0-22-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      92.661099,
      10.928070,
      NULL,
      0.059737,
      NULL,
      5.422622,
      NULL,
      1.510911,
      0.339064,
      NULL,
      1.770106,
      NULL,
      13,
      NULL,
      2.374634,
      83.622363,
      NULL,
      0.565957,
      111.526265,
      NULL,
      32,
      NULL,
      NULL,
      NULL,
      1,
      0.299752,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      1,
      1.418927,
      17,
      1.798009,
      0.111725,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.437658,
      1,
      NULL,
      27,
      16.774758,
      18.437219,
      NULL,
      NULL,
      2,
      NULL,
      4,
      NULL,
      1.783488,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      ' 9-27-1979',
      ' 9-20-1974',
      NULL,
      ' 8-22-1981',
      ' 7-25-1985',
      '11-28-1979',
      ' 2-28-1996',
      NULL);
commit;
end;
/


