set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678963';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      '2',
      '3',
      '1',
      '2',
      '2',
      '2',
      '4',
      '2',
      '2',
      '0',
      '3',
      '1',
      '0',
      NULL,
      '0',
      '1',
      '3',
      '3',
      '0',
      '0',
      '3',
      '',
      '2',
      '',
      '3',
      '3',
      '2',
      '4',
      '2',
      '',
      '',
      '2',
      '1',
      NULL,
      '4',
      '2',
      '2',
      NULL,
      '4',
      '1',
      NULL,
      '0',
      '314',
      '23034134',
      7.141487,
      NULL,
      '2224220',
      3,
      NULL,
      1,
      NULL,
      '304311',
      NULL,
      ' 1-24-1980',
      '10-26-1991',
      81.894829,
      81.063726,
      18.873833,
      10,
      26,
      2,
      8,
      10,
      NULL,
      NULL,
      20.668642,
      3.898488,
      23,
      18,
      23.375942,
      6,
      24.755308,
      NULL,
      43.910532,
      NULL,
      39.729421,
      2.008356,
      4,
      15,
      0.053298,
      NULL,
      NULL,
      7.416473,
      NULL,
      61,
      37.402268,
      ' 0-23-1982',
      NULL,
      31.374687,
      8,
      NULL,
      184.994475,
      NULL,
      ' 3-18-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      5,
      34,
      7.030215,
      NULL,
      ' 9-13-2002',
      1,
      0.316571,
      67.937859,
      0.053242,
      1,
      NULL,
      0,
      1,
      28.628822,
      NULL,
      NULL,
      NULL,
      ' 9- 4-1992',
      40.201317,
      6,
      40.700963,
      41.085072,
      21,
      51,
      57,
      NULL,
      28,
      2.278017,
      65.265128,
      52,
      '10-10-1980',
      2,
      7,
      19.339447,
      45.678145,
      45,
      NULL,
      6.450225,
      ' 3-28-1974',
      13,
      3,
      ' 3- 2-1976',
      NULL,
      19,
      4.871777,
      11.533155,
      4.737386,
      NULL,
      1,
      23.958074,
      1,
      66,
      1,
      0.847078,
      1,
      29.198418,
      1.589358,
      1,
      NULL,
      1,
      ' 8-23-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      104.879878,
      NULL,
      ' 7- 3-1985',
      NULL,
      NULL,
      NULL,
      14,
      '11-26-2000',
      14.681994,
      ' 2-23-1982',
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      22.095792,
      ' 4- 2-1996',
      NULL,
      40,
      45,
      ' 3- 9-1994',
      NULL,
      63.439278,
      ' 6-13-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


