set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637027';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4013',
      NULL,
      '10432240',
      NULL,
      '32143104',
      '44302310',
      '40121412',
      '11132122',
      '43133443',
      '30112241',
      NULL,
      '30422313',
      '41300101',
      '00401123',
      '22431143',
      '23312422',
      '22142224',
      '00310143',
      '03012404',
      '33102111',
      '01430200',
      NULL,
      '21043443',
      NULL,
      '21124010',
      '24343140',
      '04404014',
      '30431214',
      NULL,
      '31112214',
      '14141111',
      '44020203',
      '13104323',
      '33012332',
      '21134014',
      '11141303',
      NULL,
      '23440203',
      '23241104',
      '02234212',
      '02143040',
      '01230113',
      NULL,
      '24340344',
      '32430334',
      '232',
      '20',
      6,
      11.346281,
      '1303400',
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      ' 0-26-1985',
      ' 8-17-1989',
      18,
      NULL,
      35,
      18,
      NULL,
      4,
      NULL,
      19.965956,
      31,
      24,
      16.124919,
      19,
      22.925943,
      26,
      4,
      11.711577,
      13,
      14,
      47,
      7.801858,
      29.434177,
      NULL,
      20.492831,
      4,
      1.404564,
      23.709616,
      181.144863,
      57,
      154.143605,
      153.802026,
      136,
      ' 0-12-1992',
      25,
      2,
      15,
      26.032535,
      23.764395,
      7,
      '11-24-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      6,
      16,
      6.213805,
      42,
      1.236463,
      ' 4-19-1999',
      1,
      0,
      133.914950,
      0.502685,
      0.395941,
      36.389687,
      0,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      ' 4-15-2000',
      47.937749,
      26,
      NULL,
      36.518220,
      9,
      26.561112,
      24.913353,
      68,
      NULL,
      NULL,
      85.131653,
      NULL,
      ' 4- 9-1995',
      2.362041,
      NULL,
      NULL,
      38,
      19,
      58,
      NULL,
      ' 3-14-2002',
      NULL,
      7.836606,
      NULL,
      11,
      7.167432,
      NULL,
      3.405245,
      14.165876,
      5.676798,
      0,
      0.937006,
      0.087220,
      42,
      NULL,
      0,
      NULL,
      17.644678,
      5.261242,
      5.124230,
      4.527405,
      4.139787,
      ' 3-19-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      8.010203,
      5,
      ' 8-21-1994',
      NULL,
      NULL,
      NULL,
      34,
      ' 7-18-1977',
      11,
      ' 3-11-1980',
      11.800912,
      5.224363,
      ' 3-15-1980',
      78.052516,
      NULL,
      ' 5-11-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      ' 1-20-1996',
      44,
      12,
      18,
      '11-26-1992',
      1.397381,
      12.007581,
      ' 8-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


