set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686962';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0130',
      '44130031',
      '14331341',
      NULL,
      '02414211',
      '22401334',
      '13402213',
      NULL,
      NULL,
      '42021022',
      '40203333',
      '34123201',
      '21322332',
      '33202240',
      '40012033',
      '24034442',
      '22401211',
      '03014233',
      '44304100',
      '03204341',
      '21042011',
      '30213020',
      NULL,
      '01331241',
      '32302044',
      '02321322',
      NULL,
      '03101311',
      '33240332',
      '13321121',
      '44403220',
      '01340203',
      '00114124',
      '03244231',
      NULL,
      '44344123',
      NULL,
      '42104201',
      '31142322',
      NULL,
      NULL,
      '14301334',
      '31342413',
      '02344112',
      NULL,
      NULL,
      '03',
      2.525369,
      18,
      '0211313',
      1,
      NULL,
      0,
      NULL,
      '310240',
      0.637682,
      ' 2- 5-1991',
      NULL,
      44,
      NULL,
      40,
      6.386959,
      5,
      9,
      NULL,
      4,
      5.464721,
      8.617371,
      18,
      4.969766,
      NULL,
      NULL,
      24,
      17.699901,
      17,
      0.101869,
      NULL,
      22.274136,
      31,
      10,
      59,
      NULL,
      1.004641,
      NULL,
      36.570759,
      23,
      89.242480,
      210,
      33,
      ' 8-14-1977',
      38.855523,
      54.690532,
      13.378576,
      NULL,
      149.061042,
      136.679593,
      ' 2-20-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.115552,
      9,
      3.402234,
      2.233528,
      ' 9-26-1989',
      1,
      NULL,
      74,
      0.374719,
      NULL,
      102,
      0.572893,
      0,
      70,
      NULL,
      NULL,
      NULL,
      ' 4-21-1976',
      47,
      NULL,
      118.304632,
      61,
      9,
      74,
      NULL,
      94,
      30.247587,
      19.381015,
      72,
      63.907394,
      ' 6-10-1979',
      16.140999,
      5,
      1.672703,
      NULL,
      NULL,
      70.475291,
      1,
      NULL,
      12,
      12.365298,
      ' 6-10-2000',
      6.614065,
      17,
      7,
      4,
      NULL,
      3.536056,
      1.422852,
      9,
      0.297655,
      NULL,
      7,
      3.886089,
      6.576132,
      20.556890,
      3.092942,
      4.150264,
      2.640008,
      0.126962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.277343,
      28.072489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-12-1975',
      42.576146,
      ' 1- 0-1984',
      11.177998,
      16.779406,
      ' 0-11-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      21,
      NULL,
      1,
      37,
      8.170142,
      ' 1- 9-1998',
      1,
      NULL,
      '11- 5-2000',
      NULL,
      NULL,
      12.229451,
      41.429398,
      '10-11-1981',
      56.811288,
      1,
      19.175882,
      '10- 0-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


