set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9519085';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4042',
      '10141322',
      '03123430',
      '12431444',
      '40014011',
      '44043430',
      '00430141',
      '20433224',
      '31113123',
      '41431130',
      '11341424',
      NULL,
      '23300330',
      '24312144',
      NULL,
      NULL,
      '24421312',
      '40440342',
      '30020120',
      '30331302',
      '00412212',
      NULL,
      '40411030',
      '03323342',
      '11320242',
      '42311402',
      '21020100',
      '21200430',
      '32410242',
      NULL,
      '42000421',
      '42424403',
      '32143322',
      '13204122',
      '11322213',
      '41123211',
      '44241213',
      '43244013',
      '10130144',
      '32423240',
      '22042242',
      '01344034',
      '32401412',
      NULL,
      '04412344',
      NULL,
      '21',
      NULL,
      NULL,
      '0001242',
      NULL,
      0.398891,
      1,
      NULL,
      '401113',
      NULL,
      NULL,
      ' 5-18-1983',
      NULL,
      NULL,
      30,
      15.427538,
      22.761962,
      8.895176,
      75.273523,
      15,
      17,
      24.362884,
      19.642746,
      NULL,
      21.979738,
      17.970569,
      0.008314,
      17.810273,
      0.249903,
      18.330354,
      29,
      10.561509,
      NULL,
      18.475041,
      38.171216,
      7.246563,
      0,
      113.936019,
      60.485172,
      116.815648,
      57.157721,
      221,
      NULL,
      '11-23-1997',
      44,
      24.345038,
      NULL,
      24.175534,
      198,
      NULL,
      NULL,
      1.787858,
      1,
      4,
      1,
      NULL,
      1.298032,
      1,
      1,
      0.821523,
      0.533452,
      1,
      1,
      0,
      0,
      0,
      1.663683,
      1.369219,
      1.513293,
      0.489314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1994',
      110,
      NULL,
      NULL,
      1.162567,
      6.076599,
      6.300950,
      ' 6-27-1999',
      1.713678,
      0,
      NULL,
      1.600134,
      2,
      NULL,
      1.171557,
      0.268796,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 6-1991',
      106.468227,
      119.509122,
      109,
      76,
      125.945884,
      36,
      17,
      58.978522,
      19,
      37,
      NULL,
      85,
      ' 7-11-1976',
      4,
      17.219408,
      0,
      0,
      19,
      NULL,
      1,
      ' 5- 7-1988',
      19.119153,
      23,
      ' 5- 7-1976',
      12,
      22.717693,
      24.406725,
      12,
      13.909328,
      6,
      0.623497,
      26,
      1.359715,
      64,
      0,
      1.796490,
      31,
      16.097205,
      1.484900,
      NULL,
      1,
      1,
      ' 1-26-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.655051,
      ' 8-24-1995',
      29,
      NULL,
      NULL,
      NULL,
      ' 9-12-1993',
      44,
      57.049920,
      ' 6-12-1975',
      3,
      1,
      ' 8-24-1985',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      12.165362,
      NULL,
      15.465309,
      13.347594,
      0.997191,
      ' 4-10-1994',
      0,
      120,
      ' 7-15-2001',
      6.686723,
      NULL,
      7.059707,
      13.649844,
      ' 0-21-1994',
      19.788890,
      1,
      180.634262,
      ' 7- 9-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


