set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7937168';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13101331',
      '31431004',
      '03442220',
      '11412303',
      NULL,
      '21400312',
      '20402344',
      NULL,
      '12133441',
      NULL,
      '21204410',
      '02133232',
      NULL,
      '04212010',
      '14133443',
      NULL,
      '43304334',
      '32413322',
      '11041031',
      '33401444',
      '23122104',
      '12423403',
      '22304324',
      '11140341',
      '00021104',
      NULL,
      NULL,
      '20030330',
      '34132424',
      NULL,
      '02331114',
      '00131122',
      '01044130',
      NULL,
      '14410320',
      '40324421',
      '32242024',
      '43443121',
      '12213110',
      '23003443',
      '00440332',
      '44423102',
      '21222201',
      '34310021',
      '040',
      NULL,
      NULL,
      NULL,
      '3312043',
      3,
      1.892332,
      3,
      NULL,
      '041422',
      3.809137,
      NULL,
      NULL,
      39.992241,
      NULL,
      20.692403,
      12.650905,
      NULL,
      8,
      68,
      1.366628,
      29.783539,
      21,
      39,
      18.383330,
      43,
      20,
      8,
      19.410304,
      16.964881,
      5,
      60.906771,
      1,
      39.266702,
      0.186534,
      NULL,
      1,
      0.972650,
      25,
      217,
      20.650144,
      71.011203,
      NULL,
      154,
      ' 6- 8-1989',
      23.687282,
      55,
      16.809124,
      6,
      43,
      196.898044,
      NULL,
      0,
      1,
      1,
      0.977416,
      5.574651,
      0,
      3.603309,
      0.286455,
      0.745317,
      1.504212,
      3.220569,
      0,
      0,
      1,
      NULL,
      NULL,
      0.925535,
      1,
      0,
      0.210526,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 8-1996',
      35.720195,
      15.173623,
      6,
      6,
      NULL,
      4.789719,
      ' 1-25-1999',
      1,
      0,
      173,
      0.470016,
      NULL,
      83,
      1,
      3.358366,
      73,
      1,
      1,
      204.158831,
      '10-21-1996',
      62,
      0,
      72.916835,
      70,
      47,
      52.660488,
      52.831462,
      NULL,
      NULL,
      46.645111,
      89.908620,
      72.047889,
      ' 6-10-1996',
      24.692673,
      16.196458,
      5.626098,
      53.980360,
      NULL,
      146,
      13,
      '11-28-1991',
      10,
      NULL,
      ' 8-24-1974',
      13,
      19.764593,
      23.487419,
      12.752324,
      NULL,
      NULL,
      0,
      4,
      1.101091,
      100,
      0,
      NULL,
      NULL,
      17.402863,
      3,
      1.033789,
      0.173023,
      1,
      ' 4-14-2000',
      NULL,
      5.742687,
      1,
      '11- 0-1991',
      76.520440,
      NULL,
      ' 7-14-1997',
      19.268381,
      14,
      NULL,
      46,
      ' 9- 2-1979',
      22,
      ' 6-23-1995',
      NULL,
      6,
      NULL,
      NULL,
      67,
      ' 9-27-1974',
      7,
      NULL,
      ' 6- 5-1984',
      0.182103,
      1,
      ' 8-25-1981',
      2,
      1,
      8.171493,
      ' 8- 5-1975',
      31.728656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


