set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016374';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1330',
      NULL,
      '21144230',
      '10213003',
      '42314121',
      NULL,
      '42222300',
      NULL,
      '02400421',
      '43110414',
      '00142221',
      '44023040',
      '03120021',
      '33420034',
      '12024212',
      '13430441',
      '40203113',
      '24124134',
      '23441020',
      '11232021',
      '32212420',
      '33414402',
      '41102010',
      NULL,
      '20443044',
      '20131414',
      NULL,
      '34140103',
      '43112132',
      '02340013',
      '40030442',
      '03133121',
      '40134042',
      NULL,
      NULL,
      '11021014',
      '41033322',
      '22111013',
      '43131243',
      '33340402',
      '44212211',
      '13031122',
      '04402403',
      '04242112',
      '21343342',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 3-1977',
      NULL,
      NULL,
      1,
      6.609102,
      25,
      NULL,
      73.757951,
      16.429054,
      15,
      NULL,
      34,
      19.621017,
      6,
      8.847762,
      21,
      12,
      0.633223,
      23.599314,
      36.871551,
      13.762277,
      NULL,
      4.462496,
      38.748713,
      NULL,
      NULL,
      82,
      20.577936,
      11.532653,
      30,
      NULL,
      58.288668,
      ' 3-20-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.522812,
      1.717439,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.454483,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 3-1983',
      NULL,
      NULL,
      5,
      14,
      6.642760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86.997511,
      NULL,
      62.716951,
      NULL,
      94.946994,
      12,
      110,
      70,
      19.569147,
      31,
      NULL,
      83.356217,
      ' 8-12-1986',
      NULL,
      43,
      NULL,
      NULL,
      81.769469,
      136.021284,
      9,
      '11-19-1996',
      16,
      NULL,
      ' 2-26-1983',
      0,
      NULL,
      12.454278,
      NULL,
      4,
      3.783392,
      NULL,
      NULL,
      NULL,
      41,
      NULL,
      NULL,
      11.808411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52.244229,
      17.492511,
      NULL,
      ' 0-25-1987',
      1,
      79.180699,
      ' 6- 2-1995',
      10.830560,
      5,
      19,
      NULL,
      ' 3- 9-1986',
      3,
      0.356642,
      13.422681,
      ' 7- 1-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      90.540693,
      1,
      22.772277,
      22.824699,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      10,
      20.244116,
      0.320781,
      0.975759,
      26.883222,
      NULL,
      NULL,
      NULL,
      1.923381,
      0,
      33.161836,
      1,
      NULL,
      131.934425,
      36,
      NULL,
      75.637091,
      0,
      78,
      0.733080,
      0,
      1.600921,
      0.545788,
      0.033308,
      NULL,
      55.443294,
      84,
      21,
      NULL,
      53.695222,
      75.944043,
      0.341667,
      1,
      65.750548,
      1.973511,
      0.349152,
      0.587675,
      28.129456,
      1,
      4,
      0,
      56,
      0.939579,
      0.099111,
      35.168455,
      35,
      9,
      NULL,
      58,
      53,
      26,
      22.211829,
      1.430800,
      5.647740,
      1,
      3.501608,
      1.406791,
      1.859978,
      1,
      3.803189,
      87,
      NULL,
      '11- 9-1995',
      ' 8- 3-2000',
      ' 5-21-1979',
      ' 0-28-2001',
      NULL,
      NULL,
      NULL);
commit;
end;
/


