set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016374';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34320443',
      '31442300',
      '33144121',
      NULL,
      '04441432',
      '21333242',
      '40230304',
      '33434244',
      '00240000',
      '20122314',
      NULL,
      '10322224',
      NULL,
      '31331141',
      '10334402',
      '30102314',
      '40210404',
      '00321111',
      '04220304',
      '44301421',
      '20243341',
      '31441200',
      '14040213',
      '01222133',
      '44212300',
      '43030444',
      '23340123',
      '20212344',
      NULL,
      '33322430',
      '02211011',
      '01041410',
      NULL,
      '40421433',
      '11303322',
      '21113343',
      '12401122',
      '10210421',
      '10142100',
      '40322020',
      NULL,
      '23430203',
      '13102211',
      '41100242',
      '021',
      NULL,
      NULL,
      NULL,
      NULL,
      1.113519,
      65,
      1,
      NULL,
      '323123',
      1.208305,
      ' 6- 4-1975',
      ' 2-13-1986',
      74,
      NULL,
      1,
      NULL,
      18,
      1.781230,
      15,
      12,
      15.843750,
      1.333477,
      28.839723,
      3.323295,
      NULL,
      5,
      24,
      NULL,
      5.181523,
      8,
      NULL,
      NULL,
      22.184490,
      17.364300,
      60.448799,
      2,
      1,
      14,
      131.002626,
      58.428977,
      96,
      139,
      154,
      ' 2-11-1985',
      6.086462,
      10.927767,
      15,
      5,
      9,
      93.304075,
      ' 3- 6-2002',
      0.567726,
      NULL,
      NULL,
      1,
      3.246987,
      3.357500,
      4,
      1,
      0,
      0.857547,
      1.945603,
      NULL,
      0.113048,
      0,
      1,
      1,
      2,
      1.497912,
      1,
      5.779913,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-17-1999',
      42.805039,
      NULL,
      8.172790,
      4,
      4.427661,
      0.309635,
      '11- 3-1987',
      3,
      0.021268,
      NULL,
      1.704223,
      0.051278,
      115.445371,
      0.209707,
      0,
      17.320360,
      NULL,
      NULL,
      NULL,
      ' 2- 1-1979',
      45,
      NULL,
      49.993434,
      5.423958,
      NULL,
      3.843059,
      93,
      36.042644,
      20.574803,
      NULL,
      46,
      23.650300,
      NULL,
      NULL,
      18.283282,
      3,
      40.798980,
      66,
      NULL,
      1,
      ' 1- 1-1994',
      21,
      6.679257,
      ' 0-10-1982',
      9,
      4.279331,
      2.545702,
      20.542224,
      0,
      6,
      0,
      7.060202,
      0.376101,
      NULL,
      0,
      4,
      NULL,
      20.879872,
      1,
      NULL,
      0,
      NULL,
      ' 9- 0-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      38.058730,
      23,
      ' 2-22-1980',
      NULL,
      NULL,
      NULL,
      33,
      ' 9-18-1996',
      0.376080,
      '10- 9-1988',
      8,
      3,
      ' 9- 5-1994',
      43.841160,
      36.874828,
      ' 1-14-1986',
      0.998823,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      ' 7-16-1977',
      17,
      1,
      12,
      ' 0- 5-1999',
      4.591275,
      NULL,
      ' 8-18-1997',
      NULL,
      NULL,
      20.571153,
      25,
      ' 5- 8-1985',
      14,
      1.832414,
      81,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


