set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016374';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '1',
      '1',
      '0',
      '3',
      NULL,
      '4',
      '4',
      '3',
      '3',
      NULL,
      '4',
      '1',
      '4',
      '1',
      NULL,
      '0',
      NULL,
      '2',
      '2',
      '3',
      '4',
      '4',
      NULL,
      '2',
      '',
      '3',
      '4',
      NULL,
      '3',
      '3',
      '',
      '',
      '2',
      NULL,
      '4',
      '2',
      '1',
      '3',
      NULL,
      '0',
      '2',
      '3',
      '2',
      NULL,
      '01',
      3,
      40,
      '4024112',
      NULL,
      132,
      NULL,
      NULL,
      '421110',
      0,
      ' 7-14-1976',
      NULL,
      85.567794,
      99.305861,
      NULL,
      8,
      NULL,
      10.688471,
      NULL,
      NULL,
      15.208412,
      2.036646,
      5.579839,
      11.837615,
      15.197235,
      11.967140,
      16,
      25,
      NULL,
      NULL,
      NULL,
      6.499095,
      20,
      18.985634,
      14.496930,
      14,
      1,
      NULL,
      109,
      31.972479,
      NULL,
      11,
      134.945482,
      NULL,
      31.305883,
      20.138848,
      7,
      5,
      74.716943,
      132,
      ' 4-17-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.736843,
      44.604564,
      19.567258,
      15.270256,
      2.007941,
      4,
      ' 2- 7-2003',
      NULL,
      3,
      214,
      1.830630,
      NULL,
      14.373189,
      NULL,
      1,
      15,
      NULL,
      NULL,
      NULL,
      ' 1-26-1985',
      55,
      75.585026,
      57.360609,
      51.782256,
      83,
      52,
      74,
      34,
      13.896529,
      29,
      85,
      NULL,
      ' 1-12-1980',
      2.282465,
      17,
      11.829888,
      12,
      NULL,
      41.029452,
      11,
      ' 0- 2-1981',
      19.577434,
      2,
      ' 9-13-2000',
      NULL,
      8,
      NULL,
      NULL,
      5.199540,
      5,
      NULL,
      NULL,
      NULL,
      17.227481,
      0.928347,
      1.784411,
      17,
      4.349163,
      NULL,
      6,
      1.051389,
      0.600181,
      ' 9-28-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      94.159145,
      5,
      ' 3- 9-1999',
      NULL,
      NULL,
      NULL,
      43,
      ' 0- 2-1991',
      0,
      NULL,
      5.698713,
      15,
      ' 2- 8-1978',
      46.901165,
      14,
      ' 0-28-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      ' 3-20-1978',
      18,
      0,
      NULL,
      ' 2- 7-1989',
      1.038952,
      18,
      '10- 5-1996',
      NULL,
      18,
      7.404547,
      12.568898,
      ' 5-11-1990',
      46,
      1.512497,
      NULL,
      ' 6-19-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


