set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8920666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1330',
      NULL,
      NULL,
      '13121013',
      '43212431',
      NULL,
      '21222340',
      '42144203',
      '20103232',
      '31420312',
      '10234430',
      '40203200',
      '11102313',
      '23440131',
      '02333232',
      NULL,
      '02323444',
      '13403103',
      '40010201',
      '34144034',
      NULL,
      NULL,
      '00013224',
      '23234403',
      '32123411',
      NULL,
      NULL,
      NULL,
      '41112212',
      '20243031',
      NULL,
      '22010114',
      NULL,
      '43412041',
      NULL,
      '31413422',
      '12134403',
      '14210403',
      NULL,
      '12011203',
      '12131101',
      NULL,
      NULL,
      '00242221',
      '41004443',
      '',
      '',
      NULL,
      NULL,
      '3244114',
      0,
      1.821749,
      3,
      NULL,
      '003131',
      1,
      ' 2-28-2001',
      NULL,
      4,
      NULL,
      30.171566,
      2.967493,
      5,
      13,
      43,
      NULL,
      NULL,
      1,
      28,
      NULL,
      34,
      NULL,
      17.867864,
      7.940212,
      7.397536,
      2,
      NULL,
      2,
      37.419179,
      23,
      24.260170,
      7,
      NULL,
      55,
      NULL,
      65,
      154,
      92,
      75,
      '11-25-1976',
      5,
      18,
      NULL,
      2.293153,
      NULL,
      128.261267,
      NULL,
      0.042150,
      5,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.668466,
      5,
      NULL,
      1.354231,
      0.801877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-20-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1997',
      0.853523,
      15,
      74.364632,
      62,
      44,
      91.419872,
      30,
      NULL,
      80.267994,
      14.756076,
      4,
      70.340970,
      ' 6-23-2003',
      NULL,
      0,
      8,
      NULL,
      29.247528,
      17.437762,
      0,
      ' 2- 5-1986',
      17,
      0.880835,
      ' 7-25-1996',
      3.045967,
      5.760419,
      5.102767,
      20.385362,
      4,
      10,
      NULL,
      19,
      NULL,
      73,
      6,
      1.183263,
      2.418035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-26-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.159516,
      6.907235,
      7,
      '11-17-1998',
      1.031703,
      38.315054,
      NULL,
      5,
      23.706774,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      49,
      ' 0-16-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      62,
      NULL,
      NULL,
      87,
      54,
      36.075132,
      15.477300,
      42,
      0,
      NULL,
      1,
      1.688446,
      37,
      4,
      2.661952,
      NULL,
      0,
      0.672894,
      29,
      0,
      NULL,
      213.172666,
      NULL,
      NULL,
      NULL,
      1.962113,
      NULL,
      0.286347,
      0.673985,
      NULL,
      3.911482,
      1,
      1.489800,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      1,
      NULL,
      36,
      0,
      1.040637,
      0.678987,
      4,
      1,
      NULL,
      0,
      NULL,
      0.934958,
      1,
      NULL,
      21,
      2,
      17,
      NULL,
      NULL,
      12,
      NULL,
      2,
      22.743308,
      1.982421,
      10.575521,
      5,
      0.734715,
      1.126495,
      NULL,
      NULL,
      ' 0-15-2003',
      ' 7-17-1979',
      ' 7- 0-1998',
      ' 4-16-1974',
      NULL,
      NULL,
      ' 1- 1-1997',
      NULL);
commit;
end;
/


