set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119898';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0312',
      '42032431',
      '11413044',
      NULL,
      '44300203',
      NULL,
      NULL,
      '20112243',
      '44301112',
      '40434231',
      NULL,
      '40212022',
      '02230140',
      NULL,
      '01311444',
      '04412343',
      '30423240',
      '30010130',
      '31431441',
      '21233220',
      NULL,
      '44312124',
      '41202444',
      '30433213',
      '22243231',
      '30310224',
      NULL,
      '23131200',
      '04234302',
      NULL,
      '03241241',
      '32321343',
      '22434333',
      '12242332',
      '44113020',
      '22412211',
      '14032344',
      '24440134',
      '42122303',
      NULL,
      '11422433',
      '42441433',
      '40404321',
      '14133410',
      '24002030',
      '030',
      '01',
      NULL,
      NULL,
      '4214133',
      0,
      0.304264,
      3,
      NULL,
      '040411',
      1.842063,
      NULL,
      ' 0- 2-1978',
      21,
      NULL,
      36.123918,
      17.440721,
      NULL,
      NULL,
      105.992212,
      9.938320,
      23.745322,
      30.935159,
      27,
      16,
      NULL,
      13.641885,
      15,
      2.881625,
      31,
      10.590838,
      24.190322,
      18,
      8,
      23.933761,
      107,
      19,
      0.246975,
      NULL,
      NULL,
      NULL,
      34.608666,
      167.389249,
      NULL,
      ' 3-20-1989',
      62,
      24,
      22.102454,
      14.745913,
      NULL,
      NULL,
      ' 5-15-1994',
      0.800447,
      0.731894,
      3.698593,
      NULL,
      5,
      0.808084,
      2.707447,
      0,
      0,
      1,
      0,
      NULL,
      1.464965,
      1.275280,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-12-1980',
      78,
      22,
      16.749487,
      NULL,
      7,
      3.182369,
      ' 8-23-1988',
      0.154686,
      0,
      156,
      1,
      0,
      26.666961,
      6.091763,
      NULL,
      NULL,
      3.862507,
      2,
      22,
      ' 9- 2-1990',
      4,
      NULL,
      34.181911,
      85,
      91.488506,
      101.508291,
      77.007951,
      13,
      NULL,
      15,
      40.950903,
      39.898202,
      ' 3-22-2000',
      NULL,
      6,
      NULL,
      27.539989,
      38,
      NULL,
      5.513722,
      ' 8-15-1985',
      6,
      26,
      ' 7- 2-1989',
      4.714873,
      10.891186,
      14,
      19.374713,
      10.976397,
      8.836192,
      0.104877,
      23,
      1.622214,
      145,
      1.469345,
      9.104963,
      16.191413,
      15,
      2,
      NULL,
      0.853141,
      1.134817,
      NULL,
      2.136203,
      2,
      1.955937,
      '10- 2-1979',
      103,
      3.295077,
      ' 0-22-1989',
      NULL,
      4.575120,
      ' 7-29-1977',
      47,
      ' 7-22-2002',
      31.565859,
      ' 0-20-1974',
      0,
      19.441489,
      ' 7-14-1992',
      NULL,
      80.004245,
      '11- 6-1975',
      3.684251,
      0,
      ' 7- 1-1977',
      8,
      3.804710,
      ' 6-13-2003',
      2,
      2,
      14.472078,
      ' 5- 0-2003',
      56,
      9.032994,
      11.966998,
      ' 8- 7-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


