set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2024',
      '10201432',
      '12002332',
      NULL,
      '11040040',
      '12423131',
      '24231023',
      '11234003',
      '01311333',
      '23344143',
      '21240141',
      '00144402',
      '14022222',
      '20324200',
      '02042333',
      NULL,
      '11313410',
      '33320210',
      '11231422',
      '40442044',
      '11420011',
      '14200044',
      '21240414',
      NULL,
      '03303103',
      '13224122',
      NULL,
      '12303030',
      '43220041',
      '34411331',
      NULL,
      '22330420',
      '41303032',
      '12420442',
      '00010420',
      '10432020',
      '20324240',
      '22111440',
      '32230214',
      '11104000',
      NULL,
      '41000101',
      '42044012',
      NULL,
      '01404341',
      '',
      '',
      NULL,
      NULL,
      '3113440',
      NULL,
      0.322089,
      NULL,
      NULL,
      '034243',
      0.745121,
      ' 9- 6-1983',
      NULL,
      11.726208,
      NULL,
      NULL,
      4,
      0,
      2.939962,
      45,
      11,
      23.834018,
      7,
      16,
      2.791885,
      23.338893,
      9,
      1,
      17.748771,
      22.864649,
      14.000218,
      68,
      6.416913,
      47,
      11,
      24,
      NULL,
      NULL,
      66,
      11.058502,
      NULL,
      118,
      NULL,
      66.165672,
      ' 9- 5-1976',
      60,
      22.746951,
      NULL,
      25.815624,
      23.806976,
      21.033955,
      '11- 7-1998',
      3,
      5.200646,
      0.536271,
      0.207510,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.693607,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 3-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-11-1999',
      51,
      92.990903,
      21.554938,
      27,
      NULL,
      86,
      0.645053,
      83,
      54.818552,
      NULL,
      133.907708,
      NULL,
      '10-23-1980',
      18.063659,
      8,
      20,
      99,
      90.288881,
      111.981137,
      11.609139,
      NULL,
      17.944719,
      2,
      ' 4-20-1976',
      NULL,
      4.285807,
      17,
      7,
      NULL,
      6.713571,
      NULL,
      4.302776,
      NULL,
      35,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      23.914287,
      36,
      ' 2-13-1979',
      0,
      33,
      ' 1- 7-1998',
      11.870611,
      NULL,
      NULL,
      13,
      ' 8-11-1977',
      51.191023,
      0,
      102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.806395,
      22.832228,
      36.239076,
      41,
      1,
      NULL,
      5,
      8.313521,
      3,
      1.787646,
      NULL,
      0,
      0.917515,
      54.744889,
      1,
      1,
      NULL,
      2,
      3.721765,
      69.365501,
      NULL,
      0.886932,
      139,
      NULL,
      7.259248,
      9.923252,
      1.459926,
      NULL,
      0.669948,
      1,
      NULL,
      0,
      NULL,
      1.221872,
      32,
      7,
      85.958540,
      NULL,
      9,
      NULL,
      0,
      0,
      NULL,
      1.343435,
      NULL,
      3,
      35,
      1,
      96.165665,
      1,
      82,
      NULL,
      1,
      29,
      8,
      NULL,
      13.434426,
      NULL,
      NULL,
      20.421998,
      71,
      14,
      1,
      2.143513,
      1.873556,
      0,
      3.126876,
      1.380027,
      NULL,
      89.428043,
      ' 0-25-1984',
      ' 8-11-1977',
      ' 6-22-1995',
      ' 6-15-1988',
      ' 7- 2-1974',
      ' 8- 3-2001',
      '11-28-1975',
      NULL);
commit;
end;
/


