set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2410',
      '11132401',
      NULL,
      NULL,
      NULL,
      '21132132',
      '23340442',
      '33021301',
      '34212242',
      '03331314',
      '14300204',
      '33204421',
      '11411010',
      '30231104',
      '01343323',
      '44332401',
      '42311022',
      NULL,
      NULL,
      '20240112',
      '22413201',
      NULL,
      '00140100',
      '22112442',
      '44321212',
      '24434003',
      '40020030',
      '43124013',
      '34302410',
      '24023022',
      '22121234',
      '43433024',
      NULL,
      '13140132',
      '04201312',
      '44032422',
      '34340313',
      '04330034',
      '32201113',
      NULL,
      '30103243',
      '22042024',
      '22221231',
      NULL,
      '32221233',
      '221',
      NULL,
      NULL,
      NULL,
      '4003214',
      0,
      15,
      3,
      NULL,
      '421003',
      4.880603,
      ' 1- 5-1983',
      NULL,
      5,
      NULL,
      7,
      20.763510,
      20.120350,
      13,
      76,
      10.650661,
      35,
      17,
      30,
      7.246656,
      16,
      NULL,
      37.930721,
      23.911640,
      40,
      25.585183,
      105,
      28,
      12,
      NULL,
      NULL,
      22,
      NULL,
      32,
      222.639919,
      3.612944,
      8,
      299,
      192.892913,
      ' 6-22-1998',
      42,
      35.397515,
      28,
      8,
      67,
      83.847223,
      '11-15-1985',
      1.742150,
      0.347973,
      1.921171,
      NULL,
      NULL,
      NULL,
      1.251485,
      1,
      1,
      0,
      4.714876,
      1,
      1.988123,
      1.168412,
      NULL,
      0.358536,
      0,
      1.595373,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-20-1996',
      90,
      8.403237,
      7,
      NULL,
      7,
      7,
      NULL,
      1.333865,
      0.287968,
      59.030262,
      NULL,
      0,
      97,
      0.587286,
      0,
      52.796596,
      NULL,
      NULL,
      NULL,
      ' 5- 3-1987',
      62.621899,
      NULL,
      25,
      NULL,
      115.465392,
      NULL,
      55.931783,
      NULL,
      NULL,
      107,
      115,
      108.810653,
      ' 6- 7-1989',
      31.213073,
      19,
      8.993426,
      NULL,
      81.339805,
      28,
      0.083591,
      '11-26-1984',
      28,
      NULL,
      NULL,
      9.480864,
      NULL,
      20.995264,
      21.834888,
      8.407686,
      0.387209,
      0.929284,
      18.665666,
      0,
      0.220848,
      1.658099,
      3,
      15,
      4.331254,
      NULL,
      1,
      NULL,
      0.669138,
      ' 4-10-1996',
      NULL,
      0.156113,
      NULL,
      ' 7- 6-1996',
      153,
      0.359348,
      ' 2- 5-1989',
      NULL,
      NULL,
      NULL,
      43.404261,
      ' 5-26-1999',
      2,
      ' 3-19-2001',
      NULL,
      6,
      NULL,
      70,
      68,
      ' 1-22-1991',
      9,
      0,
      ' 2-22-1997',
      NULL,
      NULL,
      NULL,
      3,
      3,
      12.365297,
      NULL,
      46.354835,
      6,
      57.865807,
      NULL,
      0.282608,
      84.464567,
      ' 3- 2-1997',
      4.088260,
      20,
      5.303550,
      3,
      ' 9-21-1981',
      NULL,
      0.836479,
      105.335415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.765067);
commit;
end;
/


