set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3233',
      '10400402',
      '20442312',
      '32240014',
      '23011322',
      '10411404',
      '14224404',
      '13233332',
      NULL,
      '24130320',
      '01213444',
      '40144220',
      '31421220',
      '12123310',
      '00200044',
      '42114031',
      NULL,
      '14411144',
      NULL,
      '03330244',
      '20434432',
      '34123034',
      '31232230',
      '41423024',
      '31012033',
      '02102041',
      '43034144',
      '22200321',
      '12431400',
      '41341033',
      '40413104',
      '11223002',
      NULL,
      '21431034',
      '42013232',
      '23343414',
      '30222040',
      '21333021',
      '02012230',
      '22443112',
      '10334034',
      NULL,
      '01141333',
      '23103122',
      '31214412',
      '120',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.227446,
      2,
      NULL,
      '324014',
      2.439482,
      NULL,
      NULL,
      45,
      NULL,
      18,
      20,
      19.220278,
      2,
      55,
      11.107679,
      1,
      3,
      37.296818,
      6,
      11.767883,
      15,
      NULL,
      NULL,
      NULL,
      15.492363,
      76,
      6.235277,
      NULL,
      21.481141,
      22.902183,
      10,
      NULL,
      30,
      162.303492,
      13,
      NULL,
      70.335302,
      60.603138,
      NULL,
      NULL,
      0.309390,
      26,
      NULL,
      NULL,
      161,
      NULL,
      0,
      0.846076,
      NULL,
      NULL,
      2,
      0,
      9.223884,
      1,
      1,
      0.764479,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      17.807310,
      7.414349,
      16,
      4,
      6,
      ' 2-27-1979',
      0,
      1,
      10,
      NULL,
      NULL,
      26.754684,
      0.679717,
      1.865889,
      38,
      0.485999,
      NULL,
      90.382688,
      '11- 3-1995',
      106.796652,
      NULL,
      13,
      98,
      17,
      111.000407,
      12.113931,
      5.310696,
      50.413415,
      95,
      41.763922,
      72,
      ' 2- 5-2002',
      29.918626,
      21.350777,
      5.404607,
      32,
      25.174765,
      NULL,
      6,
      '10-22-1998',
      10.499816,
      4.143654,
      NULL,
      5.205152,
      4.036378,
      6.554946,
      NULL,
      1,
      9.001596,
      0.593293,
      2,
      0,
      6.547176,
      6,
      1.385878,
      3,
      7,
      5.044578,
      NULL,
      4,
      2.848318,
      ' 7-24-1997',
      1,
      3,
      NULL,
      ' 2-10-2002',
      76,
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      ' 2-19-1993',
      42.278314,
      ' 7-24-1987',
      12,
      2,
      ' 0- 7-1984',
      106,
      74.536970,
      ' 6-17-1996',
      0.352327,
      NULL,
      ' 4- 6-1990',
      NULL,
      3,
      ' 0-18-1983',
      1,
      3,
      NULL,
      NULL,
      NULL,
      55.183266,
      22.739245,
      ' 2-14-1980',
      1,
      NULL,
      NULL,
      10.850994,
      121.572240,
      1.100337,
      NULL,
      ' 2- 0-2002',
      3,
      NULL,
      228,
      ' 3- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


