set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3412',
      '20123131',
      '41442044',
      '14343142',
      '23034144',
      '12331114',
      '21223210',
      NULL,
      '40004442',
      '21343430',
      '41340302',
      '13002431',
      NULL,
      '30003420',
      '12131230',
      '22002334',
      '41213104',
      NULL,
      '31222420',
      NULL,
      '01410143',
      NULL,
      '43230102',
      '44421030',
      '04022302',
      '40004442',
      '00043000',
      NULL,
      '34020002',
      '44140411',
      '44143041',
      '32432100',
      '24102020',
      '02211034',
      '24343134',
      NULL,
      '34303121',
      '40424241',
      '42021003',
      '34341011',
      '10211142',
      '14220200',
      '32441043',
      NULL,
      '31240244',
      '104',
      '13',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      '400400',
      0,
      ' 1-23-1978',
      '10- 2-1987',
      110,
      NULL,
      4,
      13,
      NULL,
      13.804217,
      8.983158,
      NULL,
      9.823073,
      8.050434,
      32,
      14,
      26,
      2,
      9.418664,
      7,
      29.717401,
      NULL,
      17.674375,
      11.290609,
      40.987300,
      28,
      78,
      6,
      1.423423,
      NULL,
      71,
      NULL,
      91.443264,
      193.493368,
      40,
      ' 7-12-1983',
      38,
      NULL,
      10.807259,
      14.611283,
      115,
      154,
      '10- 7-1991',
      3.247412,
      1,
      7.500218,
      3,
      11,
      NULL,
      15.133374,
      0,
      NULL,
      NULL,
      1.583790,
      2.946856,
      1,
      0.141288,
      NULL,
      1.096044,
      NULL,
      3.621853,
      1.935535,
      1.605626,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 4-1983',
      7.796612,
      NULL,
      5,
      4.369004,
      9.916533,
      2,
      ' 2- 4-1996',
      0,
      2,
      122,
      NULL,
      1.268475,
      NULL,
      0.724892,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1999',
      60.976700,
      37,
      34,
      10,
      32,
      6,
      NULL,
      6.865489,
      50.860436,
      35.927846,
      23,
      34.680329,
      NULL,
      NULL,
      13,
      6,
      NULL,
      48,
      0.500735,
      0,
      ' 1- 4-1986',
      0,
      3.244384,
      ' 5-29-1991',
      NULL,
      NULL,
      6,
      0.128115,
      10.336107,
      0,
      1,
      5.407972,
      0,
      9,
      1,
      8.921927,
      2.807820,
      27.748285,
      3.148095,
      0.888236,
      2.522364,
      0,
      ' 9-12-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 5- 3-2002',
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      19.258929,
      ' 8-23-1977',
      6.630395,
      6,
      '10-29-1982',
      51.058097,
      NULL,
      NULL,
      2,
      0.033349,
      ' 3-25-1978',
      NULL,
      NULL,
      NULL,
      3,
      0,
      8.039351,
      ' 8- 0-1994',
      14.502325,
      9,
      33,
      NULL,
      1.287418,
      NULL,
      ' 5-15-1981',
      3,
      65,
      12.546767,
      64,
      ' 2- 7-1977',
      8.596061,
      NULL,
      140,
      ' 1- 4-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


