set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3201',
      '13322310',
      '20440343',
      NULL,
      '33224143',
      NULL,
      NULL,
      '00111401',
      '10040341',
      '12002324',
      '31033234',
      '31302430',
      '13404010',
      '00032141',
      NULL,
      '02413120',
      '23221312',
      '20440033',
      '11242044',
      '02231244',
      '33313133',
      '20102410',
      '32201333',
      '40302002',
      NULL,
      NULL,
      '00324224',
      '40413321',
      NULL,
      '21200033',
      '41403044',
      '02013132',
      '14344013',
      '01244400',
      NULL,
      '31132211',
      '34243314',
      NULL,
      '44413111',
      NULL,
      '20334244',
      NULL,
      NULL,
      NULL,
      '00234432',
      NULL,
      '31',
      21,
      22.416304,
      '4413043',
      NULL,
      80,
      NULL,
      NULL,
      '022420',
      3,
      ' 2-24-2002',
      NULL,
      29,
      61,
      42,
      22.417932,
      3.050864,
      11,
      50.705995,
      9.479566,
      19,
      14.221469,
      12,
      4,
      36.400750,
      13.731444,
      1,
      20.105727,
      29.581054,
      5.850766,
      NULL,
      22.500642,
      NULL,
      6,
      81.974827,
      2.259006,
      1,
      40.939137,
      146,
      97.715600,
      116.599499,
      NULL,
      167.151444,
      NULL,
      3.246323,
      48.646440,
      30.429312,
      9.247201,
      18.373260,
      162,
      ' 5-24-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.953244,
      NULL,
      5,
      4,
      NULL,
      5,
      ' 5-24-1982',
      NULL,
      0,
      105.831670,
      1,
      2.218316,
      9.431290,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-29-2001',
      71.651897,
      25,
      85,
      99.499823,
      38,
      97.834614,
      NULL,
      83.573328,
      NULL,
      65.760506,
      38,
      NULL,
      NULL,
      NULL,
      16.874003,
      17.866552,
      47.416529,
      18,
      31.653007,
      NULL,
      ' 1-21-1995',
      16.931705,
      1.290486,
      ' 4- 0-1995',
      2,
      3,
      19,
      9.583445,
      1.758012,
      NULL,
      NULL,
      NULL,
      NULL,
      24.942207,
      1,
      1,
      11,
      NULL,
      0.650185,
      3,
      0.256147,
      NULL,
      ' 0- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      '10- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-26-1986',
      31,
      ' 9-23-1986',
      4,
      4,
      ' 8-14-1979',
      82.860037,
      65.324592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      ' 3-21-1978',
      65.275228,
      39.233889,
      23.799732,
      ' 9-24-2003',
      1.309149,
      108.847148,
      ' 5-23-1999',
      14.659200,
      160.886531,
      20.138682,
      70.285845,
      ' 7-15-1978',
      2.317701,
      1,
      213,
      '11- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


