set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '3',
      '3',
      '2',
      '3',
      '2',
      '4',
      '3',
      NULL,
      '1',
      '2',
      '3',
      '2',
      '3',
      '2',
      '2',
      '2',
      '1',
      '1',
      '2',
      '4',
      '0',
      NULL,
      '',
      '0',
      '',
      NULL,
      '4',
      '0',
      '4',
      '2',
      '',
      '',
      '3',
      '2',
      NULL,
      '0',
      '4',
      '0',
      '3',
      '0',
      '3',
      '4',
      '1',
      '333',
      '04340344',
      68,
      43,
      NULL,
      3.384040,
      112,
      3,
      1,
      '242000',
      3.964508,
      NULL,
      ' 6-20-1992',
      105,
      70,
      8,
      NULL,
      20,
      0,
      4,
      2.244048,
      19.430590,
      0,
      7,
      10.443318,
      7,
      8,
      0,
      10.928605,
      21,
      NULL,
      64.402890,
      20,
      NULL,
      NULL,
      NULL,
      0,
      0.541293,
      NULL,
      143.183709,
      38,
      NULL,
      49,
      111,
      ' 0-19-1997',
      30,
      NULL,
      22,
      14.903976,
      33.554968,
      163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54.803317,
      14.811374,
      5,
      NULL,
      8.214859,
      2.200056,
      ' 7-19-2002',
      1.756022,
      1,
      90,
      0.737452,
      1,
      114.847409,
      1.958824,
      2.669749,
      39.289392,
      NULL,
      NULL,
      NULL,
      '10- 5-1974',
      98,
      84.901888,
      38.207672,
      37,
      45,
      44,
      NULL,
      NULL,
      54,
      NULL,
      71,
      76,
      NULL,
      9.120069,
      NULL,
      23,
      70.443375,
      NULL,
      NULL,
      1.762466,
      '10- 7-2002',
      18.674556,
      19.786427,
      '10- 3-1982',
      3,
      8,
      18,
      10,
      16,
      6.797287,
      0,
      3,
      NULL,
      59.106248,
      7.527954,
      5,
      8,
      3.052486,
      1,
      8,
      1,
      0,
      ' 4- 3-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      8,
      '10-16-1980',
      NULL,
      NULL,
      NULL,
      49.332907,
      ' 9- 3-1977',
      16,
      ' 7-19-1989',
      NULL,
      NULL,
      '11- 2-1994',
      NULL,
      10,
      ' 4-21-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      16,
      ' 8-11-1994',
      15,
      10,
      14,
      NULL,
      1.699476,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0.130756,
      ' 5-21-2001',
      5,
      1,
      140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


