set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '4',
      '0',
      '4',
      '1',
      NULL,
      '1',
      '1',
      '0',
      NULL,
      '4',
      '1',
      '3',
      '3',
      '3',
      '3',
      '3',
      '0',
      NULL,
      '2',
      NULL,
      '1',
      '1',
      '',
      '2',
      '',
      '4',
      '0',
      '4',
      '3',
      '1',
      '',
      '',
      '4',
      '3',
      '3',
      '0',
      '0',
      '1',
      '0',
      '1',
      '3',
      '0',
      '1',
      '101',
      NULL,
      71,
      45,
      '4203411',
      NULL,
      26,
      1,
      NULL,
      '340132',
      5.722009,
      NULL,
      ' 8-13-1990',
      108.079742,
      156.961189,
      NULL,
      13,
      9.452220,
      NULL,
      59,
      4.993867,
      5.603423,
      9.039166,
      NULL,
      10.887031,
      37,
      NULL,
      19,
      11.854038,
      NULL,
      NULL,
      75.019578,
      NULL,
      56,
      1,
      NULL,
      2.783700,
      0.046798,
      NULL,
      37,
      37,
      62.708513,
      NULL,
      201,
      NULL,
      12,
      22.141287,
      7.828050,
      17,
      NULL,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      114.658725,
      NULL,
      7,
      3.694040,
      9.198884,
      4.061845,
      NULL,
      0.542550,
      1,
      45.709403,
      1.300256,
      0.365989,
      84,
      1,
      1.318463,
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      84,
      6.325609,
      43,
      33.704232,
      NULL,
      10,
      NULL,
      1.239793,
      14.572233,
      41,
      76,
      ' 6- 0-1994',
      5,
      NULL,
      5,
      36,
      42.224467,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      ' 5-24-1994',
      1.051369,
      4,
      4,
      5,
      18,
      NULL,
      3,
      14,
      NULL,
      78,
      0.363196,
      0.959576,
      13,
      26.430828,
      2.337668,
      NULL,
      1,
      0.003698,
      ' 3-10-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.080752,
      '10-26-1986',
      27,
      '10-20-1998',
      1.169508,
      5,
      ' 6- 1-2001',
      106.068147,
      NULL,
      ' 6-12-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      8.800897,
      ' 5- 8-1998',
      52,
      NULL,
      62,
      NULL,
      NULL,
      115,
      '10- 8-1988',
      5.173786,
      16,
      6,
      46,
      NULL,
      57.485216,
      0.066157,
      NULL,
      ' 3- 7-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


