set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9885327';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      '0',
      '4',
      '3',
      '0',
      '2',
      '1',
      '1',
      '2',
      '4',
      '4',
      NULL,
      '2',
      NULL,
      '4',
      '4',
      '2',
      NULL,
      NULL,
      '1',
      '2',
      '4',
      '',
      '2',
      '',
      '4',
      '0',
      NULL,
      '3',
      '4',
      '',
      NULL,
      '3',
      '0',
      '4',
      '4',
      '2',
      '2',
      '1',
      '3',
      '2',
      '3',
      '2',
      '101',
      '21223304',
      44,
      66,
      NULL,
      2.200354,
      0.900102,
      NULL,
      0,
      '113131',
      4,
      ' 0- 6-1988',
      ' 1- 8-1990',
      122.135431,
      43,
      45,
      12,
      NULL,
      5.577154,
      5,
      8,
      2.700902,
      16.574427,
      51,
      7.485574,
      4,
      7.086222,
      8,
      15.497212,
      NULL,
      5.348061,
      52,
      16,
      16.586461,
      NULL,
      60,
      0.540985,
      0,
      20,
      29.163963,
      NULL,
      110.619863,
      33.497617,
      190.942678,
      ' 2-18-1992',
      38.398752,
      35.193388,
      NULL,
      5,
      NULL,
      157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.851694,
      NULL,
      2.841504,
      3.907663,
      7.881098,
      6.266211,
      ' 5- 6-1982',
      1,
      NULL,
      7,
      NULL,
      1,
      NULL,
      1.603875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 9-1982',
      51.277654,
      73,
      68,
      NULL,
      NULL,
      NULL,
      63.652923,
      13,
      65,
      26,
      NULL,
      122,
      ' 5-14-1985',
      2,
      NULL,
      10,
      31.406840,
      12,
      16,
      NULL,
      ' 0-27-2002',
      21,
      31.840440,
      '10-20-1975',
      12.605089,
      NULL,
      23.943835,
      1,
      2,
      NULL,
      0,
      NULL,
      0,
      38.329784,
      0.993632,
      5,
      20,
      NULL,
      0.730052,
      0.722715,
      0,
      1,
      ' 1- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      NULL,
      ' 6-21-1976',
      NULL,
      NULL,
      NULL,
      24.516931,
      ' 3-19-1977',
      0,
      NULL,
      10,
      0.872216,
      '10-23-1984',
      5.470467,
      90,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.490588,
      ' 7- 4-2001',
      8.504274,
      9.322070,
      44,
      NULL,
      1.057472,
      NULL,
      ' 1-18-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


