set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9824368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '4',
      '4',
      NULL,
      '0',
      NULL,
      '1',
      '0',
      '0',
      '3',
      '3',
      '0',
      '0',
      '2',
      '2',
      '1',
      '0',
      '2',
      NULL,
      '3',
      '2',
      NULL,
      '3',
      '',
      '3',
      NULL,
      '3',
      '4',
      '2',
      '3',
      '3',
      '',
      '',
      '1',
      NULL,
      '3',
      NULL,
      NULL,
      '3',
      '4',
      '1',
      NULL,
      '2',
      '4',
      '130',
      '44400431',
      50.512353,
      67.264111,
      '0033444',
      0.623574,
      1,
      NULL,
      NULL,
      '244420',
      5.074664,
      ' 2-14-1978',
      ' 1- 7-1985',
      194,
      15,
      25,
      2,
      23,
      0,
      102,
      NULL,
      21,
      NULL,
      9.715553,
      9,
      0.023427,
      23.651250,
      6.136210,
      NULL,
      15,
      9.994998,
      NULL,
      4.795722,
      27.849068,
      13.093815,
      60,
      22.554089,
      1,
      132.264719,
      183.634396,
      NULL,
      61,
      53,
      NULL,
      NULL,
      22,
      NULL,
      NULL,
      NULL,
      189,
      57,
      ' 2- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      3,
      7.382172,
      4,
      7.020403,
      NULL,
      NULL,
      1.100411,
      0,
      17,
      0.225866,
      1,
      152.000499,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.614386,
      NULL,
      91,
      106,
      61.912037,
      96,
      11.048333,
      45,
      43,
      7.541465,
      58,
      53,
      ' 9-19-1986',
      NULL,
      6.413886,
      17,
      13.233434,
      72.728011,
      78,
      9.407932,
      NULL,
      15,
      16.418751,
      NULL,
      0.458206,
      NULL,
      23,
      8.921337,
      0.519077,
      NULL,
      0,
      10,
      0,
      85,
      0,
      NULL,
      3,
      15.867703,
      0.103462,
      0.481441,
      1,
      1,
      ' 2-21-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358857,
      ' 2-11-1979',
      NULL,
      NULL,
      NULL,
      6.172427,
      ' 2-17-1980',
      NULL,
      ' 2-11-1992',
      4.968573,
      12.501845,
      ' 1-11-1987',
      33,
      105.680583,
      ' 7-28-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      25,
      '11-13-1980',
      44.639315,
      29,
      NULL,
      ' 7-14-1993',
      1.835516,
      12,
      ' 4- 6-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


